# Generated by default/object.tt
package Paws::IoT::BehaviorModelTrainingSummary;
  use Moose;
  has BehaviorName => (is => 'ro', isa => 'Str', request_name => 'behaviorName', traits => ['NameInRequest']);
  has DatapointsCollectionPercentage => (is => 'ro', isa => 'Num', request_name => 'datapointsCollectionPercentage', traits => ['NameInRequest']);
  has LastModelRefreshDate => (is => 'ro', isa => 'Str', request_name => 'lastModelRefreshDate', traits => ['NameInRequest']);
  has ModelStatus => (is => 'ro', isa => 'Str', request_name => 'modelStatus', traits => ['NameInRequest']);
  has SecurityProfileName => (is => 'ro', isa => 'Str', request_name => 'securityProfileName', traits => ['NameInRequest']);
  has TrainingDataCollectionStartDate => (is => 'ro', isa => 'Str', request_name => 'trainingDataCollectionStartDate', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::BehaviorModelTrainingSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoT::BehaviorModelTrainingSummary object:

  $service_obj->Method(Att1 => { BehaviorName => $value, ..., TrainingDataCollectionStartDate => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoT::BehaviorModelTrainingSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->BehaviorName

=head1 DESCRIPTION

The summary of an ML Detect behavior model.

=head1 ATTRIBUTES


=head2 BehaviorName => Str

The name of the behavior.


=head2 DatapointsCollectionPercentage => Num

The percentage of datapoints collected.


=head2 LastModelRefreshDate => Str

The date the model was last refreshed.


=head2 ModelStatus => Str

The status of the behavior model.


=head2 SecurityProfileName => Str

The name of the security profile.


=head2 TrainingDataCollectionStartDate => Str

The date a training model started collecting data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

