# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::RU;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230112200228;

my $formatters = [
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '[0-79]',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                [0-356]2|
                4[29]|
                7|
                8[27]
              )|
              2(?:
                13[03-69]|
                62[013-9]
              )
            )|
            72[1-57-9]2
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                0(?:
                  [356]|
                  4[023]
                )|
                [18]|
                2(?:
                  3[013-9]|
                  5
                )|
                3[45]|
                43[013-79]|
                5(?:
                  3[1-8]|
                  4[1-7]|
                  5
                )|
                6(?:
                  3[0-35-9]|
                  [4-6]
                )
              )|
              2(?:
                1(?:
                  3[178]|
                  [45]
                )|
                [24-689]|
                3[35]|
                7[457]
              )
            )|
            7(?:
              14|
              23
            )4[0-8]|
            71(?:
              33|
              45
            )[1-79]
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{5})(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3-$4',
                  'leading_digits' => '
            [349]|
            8(?:
              [02-7]|
              1[1-8]
            )
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '8',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'mobile' => '9\\d{9}',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(80[39]\\d{7})',
                'toll_free' => '
          8(?:
            0[04]|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"771037", "Aktogai",
"7345", "Tyumen",
"771239", "Makat",
"772644", "Karatau",
"771644", "Arshaly",
"771145", "Karatobe\ District",
"772239", "Makanchi",
"771036", "Balkhash",
"77187", "Ekibastuz",
"7816", "Veliky\ Novgorod",
"7879", "Mineranye\ Vody",
"771331", "Martuk",
"772331", "Glubokoye",
"771040", "Zhairem\ \(GOK\)",
"772841", "Kapal",
"771841", "Aktogai",
"772833", "Usharal",
"772832", "Zhansugurov",
"771439", "Torgai",
"772439", "Aralsky\ District",
"7815", "Murmansk",
"771832", "Irtyshsk",
"772752", "Otegen\ Batyra",
"771833", "Terenkol",
"771544", "Presnovka",
"771342", "Badamsha",
"771343", "Irgiz",
"772343", "Terekty",
"772544", "Shaulder",
"772342", "Katon\-Karagai",
"7346", "Surgut",
"771454", "Karamendy",
"7833", "Kirov",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"772530", "Temirlanovka",
"771149", "Zelenovsky\ District",
"77292", "Aktau",
"772149", "Osakarovka",
"771235", "Dossor",
"771456", "Kachar",
"771457", "Dzhangildinsky\ District",
"771547", "Zhambylsky\ District",
"772546", "Sholakkorgan",
"77162", "Kokshetau\/Krasni\ Yar",
"77262", "Taraz",
"771546", "Talshik",
"772547", "Lenger",
"7494", "Kostroma",
"772435", "Zhanakorgan",
"771838", "Koktobe",
"7353", "Orenburg",
"772838", "Balpyk\ bi",
"771435", "Zhitikara",
"772348", "Kokpekty",
"771630", "Burabay",
"772257", "Shulbinsk",
"771348", "Shalkarsky\ District",
"772256", "Kainar",
"771646", "Makinsk",
"7483", "Bryansk",
"77252", "Shymkent",
"771034", "Zhezdy",
"7492", "Vladimir",
"7848", "Tolyatti",
"771647", "Esil",
"7862", "Sochi",
"77152", "Petropavlovsk",
"7395", "Irkutsk",
"7871", "Chechen\ Republic",
"772144", "Kiyevka",
"771144", "Kaztalovka",
"771645", "Stepnogorsk",
"7811", "Pskov",
"771440", "Amangeldy",
"7821", "Komi\ Republic",
"771436", "Taranovskoye",
"772437", "Zhosaly",
"771437", "Kamysty",
"7388", "Republic\ of\ Altai",
"772436", "Terenozek",
"771545", "Zhambylsky\ District",
"7341", "Udmurtian\ Republic",
"7847", "Republic\ of\ Kalmykia",
"772545", "Ikan",
"7473", "Voronezh",
"771455", "Zatobolsk",
"771236", "Makhambet",
"772237", "Ayagoz",
"7413", "Magadan",
"772778", "Chundzha",
"7423", "Primorie\ territory",
"771237", "Kulsary",
"771039", "Priozersk",
"772236", "Beskaragai",
"771649", "Zhaksynsky\ District",
"771234", "Indernborski",
"772351", "Borodulikha",
"7391", "Krasnoyarsk\ Territory",
"77112", "Uralsk",
"77212", "Karaganda",
"77185", "Shaldai",
"77273", "Almaty",
"771434", "Denisovka",
"771130", "Peremetnoye",
"771459", "Kostanai\ Region",
"772772", "Kapchagai",
"772147", "Egindybulak",
"771035", "Ulytau",
"771146", "Akzhaiksky\ District",
"772773", "Bakanas",
"772146", "Karkaralinsk",
"771147", "Akzhaiksky\ District",
"7820", "Cherepovets",
"7843", "Republic\ of\ Tatarstan",
"77279", "Almaty",
"772637", "Sarykemer",
"771636", "Shuchinsk",
"772636", "Kordai",
"771637", "Korgalzhyn",
"7427", "Chukotka\ Autonomous\ District",
"771445", "Ubaganskoye",
"771640", "Balkashino",
"772338", "Bozanbai\/Molodezhnyi",
"772937", "Kuryk",
"772640", "Moiynkumsky\ District",
"772536", "Kentau",
"7712302", "Tengizshevroil",
"772154", "Botakara",
"771537", "Timiryazevo",
"772537", "Saryagash",
"771536", "Taiynsha",
"772540", "Arys",
"771139", "Taskala",
"771540", "Kishkenekol",
"7491", "Ryazan",
"7861", "Krasnodar\ Territory",
"772842", "Kogaly",
"733", "Baikonur",
"771449", "Taranovskoye",
"772843", "Lepsy",
"771843", "Maisky\ District",
"771842", "Koktobe",
"771333", "Kandyagash",
"771332", "Uil",
"771534", "Sergeyevka",
"77102", "Zhezkazgan",
"772534", "Zhetysai",
"772332", "Shemonaikha",
"7390", "Republic\ of\ Khakassia",
"772156", "Shakhtinsk",
"772333", "Samarskoye",
"771341", "Khobda",
"7855", "Naberezhnye\ Chelny",
"772934", "Zhanaozen",
"771030", "Atasu",
"772341", "Ulken\ Naryn",
"772831", "Zharkent",
"771831", "Zhelezinka",
"772634", "Zhanatas",
"771135", "Zhanibek",
"772725", "Otegen\ Batyra",
"771136", "Chapayev",
"772137", "Saran",
"771137", "Chingirlau",
"772353", "Novaya\ Shulba",
"771444", "Uzunkol",
"7814", "Republic\ of\ Karelia",
"771140", "Saikhin",
"772539", "Kazygurt",
"7342", "Perm",
"771539", "Beskol",
"77135", "Aktobe\ Region",
"77274", "Karassaisky\ District",
"772771", "Kaskelen",
"7872", "Republic\ of\ Daghestan",
"771639", "Stepnyak",
"772639", "Saudakent",
"7812", "St\ Petersburg",
"7394", "Republic\ of\ Tuva",
"77142", "Kostanai",
"77242", "Kyzylorda",
"7496", "Moscow",
"7866", "Kabardino\-Balkarian\ Republic",
"7851", "Astrakhan",
"7487", "Tula",
"7499", "Moscow",
"771535", "Novoishimski",
"771230", "Atyrau\ Region",
"7869", "Sevastopol",
"772230", "Urdzhar",
"772535", "Shardara",
"772935", "Zhetybai",
"77122", "Atyrau",
"7383", "Novosibirsk",
"7865", "Stavropol\ territory",
"772159", "Karaganda\ Region",
"77222", "Semey",
"7495", "Moscow",
"771446", "Uzunkolsky\ District",
"771447", "Karabalyksky\ District",
"772635", "Bauyrzhan\ Mamyshuly",
"771134", "Zhympity",
"771635", "Zhaksy",
"77272983", "Kaskelen",
"771430", "Arkalyk",
"772641", "Akkol",
"771641", "Astrakhanka",
"7381", "Omsk",
"7878", "Karachayevo\-Cherkessian\ Republic",
"7712303", "Tengizs",
"771844", "Irtyshsky\ District",
"771533", "Saumalkol",
"771532", "Smirnovo",
"7818", "Arkhangelsk",
"771334", "Emba",
"772251", "Kurchatov",
"772532", "Abai",
"772334", "Tavricheskoye",
"772533", "Turkestan",
"771541", "Mamlutka",
"772932", "Beineu",
"772541", "Myrzakent",
"772632", "Merke",
"7717", "Astana",
"772633", "Asa",
"771633", "Ereimentau",
"771632", "Zerenda",
"771451", "Sarykol",
"77182", "Pavlodar",
"7424", "Sakhalin\ Region",
"7845", "Saratov",
"77282", "Taldykorgan",
"771043", "Zhairem",
"771042", "Zharyk",
"7474", "Lipetsk",
"77149", "Kostanai",
"772538", "Turara\ Ryskulova",
"771538", "Beskol",
"772336", "Ridder",
"772153", "Topar",
"771337", "Alga",
"772337", "Serebryansk",
"771336", "Khromtau",
"772938", "Fort\ Shevchenko",
"7846", "Samara",
"7472", "Belgorod",
"771031", "Aksu\-Ayuly",
"771638", "Akkol",
"772340", "Zaisan",
"772638", "Tole\ bi",
"771340", "Khobdinsky\ District",
"772830", "Alakolsky\ District",
"7484", "Kaluga",
"771141", "Zhangala",
"77272", "Almaty",
"771448", "Oktyabrskoye",
"771845", "Pavlodar\ Area",
"771335", "Shalkar",
"77213", "Aktau\/Temirtau",
"772335", "Zyryanovsk",
"7385", "Altai\ Territory",
"7863", "Rostov",
"772770", "Uzynagash",
"7482", "Tver",
"7301", "Republic\ of\ Buryatia",
"772132", "Nurinsky\ District",
"771132", "Fyodorovka",
"771133", "Aksai",
"7352", "Kurgan",
"7834", "Republic\ of\ Mordovia",
"7877", "Republic\ of\ Adygeya",
"771231", "Akkystau",
"7817", "Vologda",
"771443", "Borovskoi",
"771442", "Fyodorovka",
"772339", "Kurchum",
"771339", "Komsomolskoye",
"77224", "Barshatas",
"7841", "Penza",
"7347", "Republic\ of\ Bashkortostan",
"772431", "Zhalagash",
"771431", "Rudny",
"771138", "Zhalpaktal",
"772138", "Gabidena\ Mustafina",
"771648", "Derzhavinsk",
"772330", "Zyryanovsky\ District",
"771041", "Aktau\,\ Zhezkazgan",
"771330", "Khromtau\ District",
"7867", "Republic\ of\ North\ Ossetia",
"771840", "Bayanaul",
"772840", "Saryozek",
"771347", "Aitekebisky\ District",
"772346", "Aksuat",
"7486", "Orel",
"771346", "Shubarkuduk",
"772347", "Kalbatau",
"771836", "Sharbakty",
"772837", "Kabanbai",
"771837", "Aksu",
"772757", "Akshi",
"772836", "Karabulak",
"7384", "Kemerovo",
"772548", "Shayan",
"771458", "Kostanai\ Region",
"7485", "Yaroslavl",
"77232", "Ust\-Kamenogorsk",
"771032", "Karazhal",
"771033", "Agadyr",
"772775", "Esik",
"7382", "Tomsk",
"77132", "Aktobe\/Kargalinskoye",
"772643", "Shu",
"7343", "Ekaterinburg",
"772642", "Moiynkum",
"771642", "Egendykol",
"77272956", "Talgar",
"771643", "Atbasar",
"7836", "Republic\ of\ Marij\ El",
"7421", "Khabarovsk\ Territory",
"771531", "Bulayevo",
"772252", "Karaul",
"772531", "Aksukent",
"7411", "Republic\ of\ Sakha",
"77245", "Kyzylorda\ Region",
"7471", "Kursk",
"772834", "Ushtobe",
"7813", "Leningrad\ region",
"771834", "Uspenka",
"771542", "Kishkenekol",
"771543", "Yavlenka",
"772931", "Shetpe",
"772543", "Aqsumbe",
"772542", "Asykata",
"772344", "Akzhar",
"7873", "Ingushi\ Republic",
"771452", "Karasu",
"771453", "Auliekol",
"772631", "Kulan",
"77125", "Atyrau\ Region",
"7835", "Chuvashi\ Republic",
"771038", "Shashubai",
"771631", "Shortandy",
"772779", "Narynkol",
"772148", "Molodezhnoye",
"771232", "Atyrau\ Region",
"771233", "Ganyushkino",
"7351", "Chelyabinsk",
"77106", "Satpaev",
"7481", "Smolensk",
"7302", "Chita",
"771441", "Karabalyk",
"772433", "Aralsk",
"772759", "Almaty\ Region",
"771839", "Akku",
"772432", "Shiyeli",
"772839", "Sarkand",
"771433", "Lisakovsk",
"771349", "Shalkarsky\ District",
"771651", "Kabanbai\ Batyr",
"772774", "Talgar",
"772777", "Kegen",
"771238", "Miyaly",
"772776", "Shelek",
"771143", "Akzhaik",
"771142", "Taipak",
"736", "Simferopol",
"7426", "Jewish\ Autonomous\ Region",
"7831", "Nizhni\ Novgorod",
"7416", "Amur\ Region",
"7498", "Moscow",
"7842", "Ulyanovsk",
"771438", "Amangeldy",
"772835", "Tekeli",
"772438", "Aiteke\ bi",
"771345", "Karauylkeldy",
"772345", "Shar",
"7475", "Tambov",
"77145834", "Krasnogorsk",
"740", "Kaliningrad",
"7415", "Kamchatka\ Region",
"7844", "Volgograd",
"772131", "Abai",
"771131", "Darinskoye",};
$areanames{ru} = {"772148", "Осакаровский\ р\-н",
"771232", "Атырауская\ область",
"771233", "Курмангазинский\ р\-н",
"7351", "Челябинская\ обл\.",
"7481", "Смоленская\ обл\.",
"77106", "Сатпаев",
"771441", "Карабалыкский\ р\-н",
"7302", "Забайкальский\ край",
"772839", "Саркандский\ р\-н",
"771433", "Лисаковск",
"772433", "Аральский\ р\-н",
"772432", "Шиелийский\ р\-н",
"771839", "Лебяжинский\ р\-н",
"772759", "Алматинская\ область",
"771651", "Целиноградский\ р\-н",
"771349", "Шалкарский\ р\-н",
"772774", "Талгарский\ р\-н",
"771143", "Теректинский\ р\-н",
"772776", "Енбекшиказахский\ р\-н",
"771142", "Акжаикский\ р\-н",
"771238", "Кзылкогинский\ р\-н",
"772777", "Райымбекский\ р\-н",
"736", "Республика\ Крым",
"7416", "Амурская\ обл\.",
"7426", "Еврейская\ автономная\ обл\.",
"7831", "Нижегородская\ обл\.",
"7498", "Московская\ обл\.",
"7842", "Ульяновская\ обл\.",
"772438", "Казалинский\ р\-н",
"772835", "Текели",
"771438", "Амангельдинский\ р\-н",
"772345", "Жарминский\ р\-н",
"771345", "Байганинский\ р\-н",
"77145834", "Красногорск",
"740", "Калининградская\ обл\.",
"7475", "Тамбовская\ обл\.",
"771131", "Зеленовский\ р\-н",
"772131", "Абайский\ р\-н",
"7844", "Волгоградская\ обл\.",
"7415", "Камчатский\ край",
"771330", "Хромтауский\ р\-н",
"771648", "Жаркаинский\ р\-н",
"772330", "Зыряновский\ р\-н",
"771041", "Актау\,\ Жезказган",
"772840", "Кербулакский\ р\-н",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"771840", "Баянаульский\ р\-н",
"771346", "Темирский\ р\-н",
"7486", "Орловская\ обл\.",
"772347", "Жарминский\ р\-н",
"771347", "Айтекебийский\ р\-н",
"772346", "Тарбагатайский\ р\-н",
"771837", "Аксуский\ р\-н",
"772757", "Акший",
"7384", "Кемеровская\ обл\.",
"772836", "Ескельдинский\ р\-н",
"771836", "Щербактинский\ р\-н",
"772837", "Алакольский\ р\-н",
"772548", "Шаян",
"771458", "Костанайская\ область",
"77132", "Актобе\/Актюбинск",
"7382", "Томская\ обл\.",
"771032", "Каражал",
"77232", "Усть\-Каменогорск",
"7485", "Ярославская\ обл\.",
"772775", "Енбекшиказахский\ р\-н",
"771033", "Шетский\ р\-н",
"77272956", "Талгар",
"771642", "Егиндыкольский\ р\-н",
"771643", "Атбасарский\ р\-н",
"772643", "Шуский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"7343", "Свердловская\ обл",
"7411", "Республика\ Саха\ \/Якутия\/",
"772531", "Аксукент",
"7836", "Республика\ Марий\ Эл",
"772252", "Абайский\ р\-н",
"771531", "Магжана\ Жумабаева\ р\-н",
"7421", "Хабаровский\ край",
"77245", "Кызылординская\ область",
"7471", "Курская\ обл\.",
"7813", "Ленинградская\ обл\.",
"771834", "Успенский\ р\-н",
"772834", "Каратальский\ р\-н",
"772543", "Аксумбе",
"7873", "Республика\ Ингушетия",
"772542", "Асыката",
"772344", "Тарбагатайский\ р\-н",
"771542", "Уалихановский\ р\-н",
"772931", "Мангистауский\ р\-н",
"771543", "Есильский\ р\-н",
"771452", "Карасуский\ р\-н",
"771453", "Аулиекольский\ р\-н",
"771038", "Сыры\-Шаган",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"772779", "Райымбекский\ р\-н",
"771631", "Шортандинский\ р\-н",
"772631", "Турара\ Рыскулова\ р\-н",
"77125", "Атырауская\ область",
"7484", "Калужская\ обл\.",
"771141", "Жангалинский\ р\-н",
"771845", "Павлодар",
"77272", "Алма\-Ата",
"771448", "Карасуский\ р\-н",
"77213", "Темиртау",
"772335", "Зыряновск",
"771335", "Шалкарский\ р\-н",
"772770", "Жамбылский\ р\-н",
"7493", "Ивановская\ обл\.",
"7482", "Тверская\ обл\.",
"7385", "Алтайский\ край",
"7863", "Ростовская\ обл\.",
"7301", "Республика\ Бурятия",
"771132", "Теректинский\ р\-н",
"771133", "Бурлинский\ р\-н",
"772132", "Нуринский\ р\-н",
"7352", "Курганская\ обл\.",
"7877", "Республика\ Адыгея",
"7834", "Республика\ Мордовия",
"7817", "Вологодская\ обл\.",
"771231", "Исатайский\ р\-н",
"771443", "Мендыкаринский\ р\-н",
"771442", "Федоровский\ р\-н",
"771339", "Айтекебийский\ р\-н",
"77224", "Эмельтау",
"772339", "Курчумский\ р\-н",
"771431", "Рудный",
"772431", "Жалагашский\ р\-н",
"7841", "Пензенская\ обл\.",
"7347", "Республика\ Башкортостан",
"772138", "Бухар\-Жырауский\ р\-н",
"771138", "Казталовский\ р\-н",
"771641", "Астраханский\ р\-н",
"7381", "Омская\ обл\.",
"772641", "Таласский\ р\-н",
"771844", "Иртышский\ р\-н",
"7878", "Республика\ Карачаево\-Черкесская",
"7712303", "Тензиз",
"772532", "Абая",
"772334", "Уланский\ р\-н",
"772533", "Туркестан",
"771533", "Айыртауский\ р\-н",
"7818", "Архангельская\ обл\.",
"771532", "Аккайынский\ р\-н",
"771334", "Мугалжарский\ р\-н",
"772251", "Курчатов",
"772541", "Мырзакент",
"771541", "Мамлютский\ р\-н",
"772932", "Бейнеуский\ р\-н",
"771633", "Ерейментауский\ р\-н",
"771632", "Зерендинский\ р\-н",
"772632", "Меркенский\ р\-н",
"7717", "Астана",
"772633", "Жамбылский\ р\-н",
"771451", "Сарыкольский\ р\-н",
"7845", "Саратовская\ обл\.",
"77282", "Талдыкорган",
"77182", "Павлодар",
"7424", "Сахалинская\ обл\.",
"7474", "Липецкая\ обл\.",
"771043", "Жайрем\ \(поселок\)",
"771042", "Акой",
"77149", "Костанай",
"771538", "Кызылжарский\ р\-н",
"772538", "имени\ Турара\ Рыскулова",
"772337", "Серебрянск",
"771336", "Хромтауский\ р\-н",
"772938", "Тупкараганский\ р\-н",
"772153", "Абайский\ р\-н",
"772336", "Риддер",
"771337", "Алгинский\ р\-н",
"7472", "Белгородская\ обл\.",
"7846", "Самарская\ обл\.",
"771340", "Хобдинский\ р\-н",
"772638", "Шуский\ р\-н",
"771031", "Шетский\ р\-н",
"772340", "Зайсанский\ р\-н",
"771638", "Аккольский\ р\-н",
"772830", "Алакольский\ р\-н",
"771137", "Чингирлауский\ р\-н",
"772353", "Бородулихинский\ р\-н",
"771136", "Акжаикский\ р\-н",
"772137", "Сарань",
"771444", "Узункольский\ р\-н",
"7342", "Пермский\ край",
"771539", "Кызылжарский\ р\-н",
"772539", "Казыгурт",
"7814", "Республика\ Карелия",
"771140", "Бокейординский\ р\-н",
"77135", "Актюбинская\ область",
"77274", "Карасайский\ р\-н",
"772639", "Сарысуский\ р\-н",
"7872", "Республика\ Дагестан",
"771639", "Енбекшилдерский\ р\-н",
"772771", "Карасайский\ р\-н",
"7812", "г\.\ Санкт\-Петербург",
"77242", "Кызылорда",
"77142", "Костанай",
"7394", "Республика\ Тыва",
"7866", "Республика\ Кабардино\-Балкарская",
"7851", "Астраханская\ обл\.",
"7496", "г\.\ Москва",
"7487", "Тульская\ обл\.",
"7869", "г\.\ Севастополь",
"772535", "Шардара",
"772230", "Урджарский\ р\-н",
"771230", "Атырауская\ область",
"7499", "г\.\ Москва",
"771535", "Габита\ Мусрепова\ р\-н",
"772159", "Карагандинская\ область",
"7495", "Московская\ обл\.",
"77222", "Семипалатинск",
"772935", "Каракиянский\ р\-н",
"7383", "Новосибирская\ обл\.",
"77122", "Атырау",
"7865", "Ставропольский\ край",
"771447", "Карабалыкский\ р\-н",
"771446", "Узункольский\ р\-н",
"771635", "Жаксынский\ р\-н",
"771134", "Сырымский\ р\-н",
"77272983", "Каскелен",
"772635", "Жуалынский\ р\-н",
"771430", "Аркалык",
"7843", "Республика\ Татарстан",
"77279", "Алматы",
"7820", "Вологодская\ обл\.",
"772636", "Кордай",
"771637", "Коргалжынский\ р\-н",
"772637", "Байзакский\ р\-н",
"771636", "Щучинский\ р\-н",
"771445", "Алтынсаринский\ р\-н",
"7427", "Чукотский\ АО",
"772640", "Мойынкумский\ р\-н",
"771640", "Сандыктауский\ р\-н",
"772338", "Уланский\ р\-н",
"772937", "Каракиянский\ р\-н",
"772537", "Сарыагаш",
"771536", "Тайыншинский\ р\-н",
"7712302", "Тенгизшевройл",
"772536", "Кентау",
"771537", "Тимирязевский\ р\-н",
"772154", "Бухар\-Жырауский\ р\-н",
"771540", "Уалихановский\ р\-н",
"771139", "Таскалинский\ р\-н",
"772540", "Арыс",
"7861", "Краснодарский\ край",
"7491", "Рязанская\ обл\.",
"771843", "Майский\ р\-н",
"771842", "Майский\ р\-он",
"771449", "Тарановский\ р\-н",
"733", "Байконыр",
"772842", "Кербулакский\ р\-н",
"772843", "Лепсы",
"7390", "Республика\ Хакасия",
"772534", "Жетысай",
"77102", "Жезказган",
"772332", "Шемонаихинский\ р\-н",
"772333", "Кокпектинский\ р\-н",
"772156", "Шахтинск",
"771333", "Мугалжарский\ р\-н",
"771332", "Уилский\ р\-н",
"771534", "Шал\ Акына\ р\-н",
"771030", "Жана\-Аркинский\ р\-н",
"772341", "Катон\-Карагайский\ р\-н",
"7855", "Республика\ Татарстан",
"771341", "Хобдинский\ р\-н",
"772934", "Жанаозен",
"771831", "Железинский\ р\-н",
"772831", "Панфиловский\ р\-н",
"771135", "Жанибекский\ р\-н",
"772634", "Жанатас",
"772725", "Отеген\-Батыр",
"771645", "Степногорск",
"771144", "Казталовский\ р\-н",
"772144", "Нуринский\ р\-н",
"7871", "Республика\ Чеченская",
"7821", "Республика\ Коми",
"7811", "Псковская\ обл\.",
"771440", "Амангельдинский\ р\-н",
"771437", "Камыстинский\ р\-н",
"772436", "Сырдарьинский\ р\-н",
"7388", "Республика\ Алтай",
"771436", "Тарановский\ р\-н",
"772437", "Кармакшинский\ р\-н",
"7847", "Республика\ Калмыкия",
"772545", "Икан",
"7341", "Республика\ Удмуртская",
"771545", "Жамбылский\ р\-н",
"771455", "Костанайский\ р\-н",
"7473", "Воронежская\ обл\.",
"7423", "Приморский\ край",
"771237", "Жылыойский\ р\-н",
"772778", "Уйгурский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"771039", "Приозерск",
"771236", "Махамбетский\ р\-н",
"7413", "Магаданская\ обл\.",
"772237", "Аязог",
"772351", "Бородулихинский\ р\-н",
"771234", "Индерский\ р\-н",
"771649", "Жаксынский\ р\-н",
"77212", "Караганда",
"77112", "Уральск",
"7391", "Красноярский\ край",
"77273", "Алма\-Ата",
"77185", "Шалдай",
"771434", "Денисовский\ р\-н",
"771130", "Зеленовский\ р\-н",
"771459", "Костанайская\ область",
"772146", "Каркаралинск",
"771147", "Акжаикский\ р\-н",
"772147", "Каркаралинский\ р\-н",
"772772", "Капчагай",
"772773", "Балхашский\ р\-н",
"771146", "Акжаикский\ р\-н",
"771035", "Улытауский\ р\-н",
"771145", "Каратобинский\ р\-н",
"772239", "Урджарский\ р\-н",
"771036", "Балхаш",
"771644", "Аршалынский\ р\-н",
"77187", "Экибастуз",
"771037", "Актогайский\ р\-н",
"772644", "Таласский\ р\-н",
"7345", "Тюменская\ обл\.",
"771239", "Макатский\ р\-н",
"7816", "Новгородская\ обл\.",
"772331", "Глубоковский\ р\-н",
"771040", "Жайрем\ \(ГОК\)",
"7879", "Ставропольский\ край",
"771331", "Мартукский\ р\-н",
"771841", "Актогайский\ р\-н",
"772841", "Аксуский\ р\-н",
"772752", "Илийский\ р\-н",
"7815", "Мурманская\ обл\.",
"771832", "Иртышский\ р\-н",
"772439", "Аральский\ р\-н",
"771833", "Качирский\ р\-н",
"772833", "Алакольский\ р\-н",
"771439", "Джангильдинский\ р\-н",
"772832", "Аксуский\ р\-н",
"772343", "Курчумский\ р\-н",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"772544", "Шаульдер",
"772342", "Катон\-Карагайский\ р\-н",
"771544", "Жамбылский\ р\-н",
"771342", "Каргалинский\ р\-н",
"771343", "Иргизский\ р\-н",
"771454", "Наурзумский\ р\-н",
"7349", "Ямало\-Ненецкий\ АО",
"7833", "Кировская\ обл\.",
"77292", "Актау",
"772149", "Осакаровский\ р\-н",
"771235", "Макатский\ р\-н",
"771149", "Акжаикский\ р\-н",
"772530", "Темирлановка",
"771457", "Джангильдинский\ р\-н",
"771456", "Качар",
"771546", "Акжарский\ р\-н",
"77262", "Тараз",
"772547", "Ленгер",
"771547", "Жамбылский\ р\-н",
"77162", "Кокшетау",
"772546", "Шолаккорган",
"7494", "Костромская\ обл\.",
"771435", "Житикаринский\ р\-н",
"7353", "Оренбургская\ обл\.",
"772838", "Коксуский\ р\-н",
"771838", "Майский\ р\-он",
"772435", "Жанакорганский\ р\-н",
"771348", "Шалкарский\ р\-н",
"772256", "Алгабас",
"772257", "Шульбинск",
"771630", "Боровое",
"772348", "Кокпектинский\ р\-н",
"7862", "Краснодарский\ край",
"771647", "Есильский\ р\-н",
"7395", "Иркутская\ обл\.",
"77152", "Петропавловск",
"7492", "Владимирская\ обл\.",
"77252", "Шымкент",
"771034", "Улытауский\ р\-н",
"771646", "Буландинский\ р\-н",
"7483", "Брянская\ обл\.",
"7848", "Самарская\ обл\.",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;