/*
 * Decompiled with CFR 0.152.
 */
package opennlp.common.xml;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class XmlVerifier {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java opennlp.common.xml.XmlVerifier 'file'");
            return;
        }
        String specfile = args[0];
        boolean showfile = false;
        if (args.length > 1) {
            showfile = args[1].equals("-p");
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setValidation(true);
            Document d = builder.build(new File(specfile));
            XMLOutputter out = new XMLOutputter("  ", true);
            if (showfile) {
                out.output(d, (OutputStream)System.out);
            }
            System.out.println("\n" + specfile + " is valid.\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            System.out.println("\n" + (Object)((Object)e) + "\n");
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }
}

