/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.expression;

import java.util.List;
import opennlp.common.synsem.Category;
import opennlp.common.synsem.CategoryFcn;
import opennlp.common.unify.ModFcn;
import opennlp.common.unify.Mutable;
import opennlp.common.unify.Substitution;
import opennlp.common.unify.UnifyFailure;
import opennlp.common.unify.Variable;
import opennlp.grok.expression.AbstractCat;
import opennlp.grok.expression.Arg;
import opennlp.grok.expression.ArgStack;
import opennlp.grok.expression.CatReader;
import opennlp.grok.expression.TargetCat;
import opennlp.grok.unify.GUnifier;
import org.jdom.Element;

public final class CurriedCat
extends AbstractCat {
    private TargetCat _target;
    private ArgStack _args;

    public CurriedCat(TargetCat target, ArgStack args) {
        this._target = target;
        if (args.size() < 1) {
            System.out.println("WARNING!!! Creating a CurriedCat with empty argument stack!");
        }
        this._args = args;
    }

    public CurriedCat(TargetCat target, Arg arg) {
        this._target = target;
        this._args = new ArgStack(arg);
    }

    public CurriedCat(Element el) {
        List info = el.getChildren();
        this._target = (TargetCat)CatReader.getCat((Element)info.get(0));
        this._args = new ArgStack(info.subList(1, info.size()));
    }

    public TargetCat getTarget() {
        return this._target;
    }

    public Arg getArg(int pos) {
        return this._args.get(pos);
    }

    public Arg getOuterArg() {
        return this._args.getLast();
    }

    public Category getResult() {
        return this.getSubResult(this.arity() - 1);
    }

    public Category getSubResult(int upto) {
        if (upto == 0) {
            return this._target;
        }
        return new CurriedCat(this._target, this._args.subList(0, upto));
    }

    public ArgStack getArgStack() {
        return this._args;
    }

    public ArgStack getArgStack(int from) {
        return this._args.subList(from);
    }

    public void add(Arg a) {
        this._args.add(a);
    }

    public void add(ArgStack as) {
        this._args.add(as);
    }

    public void set(int index, Arg c) {
        this._args.set(index, c);
    }

    public void setOuterArgument(Arg c) {
        this._args.setLast(c);
    }

    public int arity() {
        return this._args.size();
    }

    public Category copy() {
        return new CurriedCat((TargetCat)this._target.copy(), this._args.copy());
    }

    public Category shallowCopy() {
        return new CurriedCat(this._target, this._args);
    }

    public void deepMap(ModFcn mf) {
        mf.modify((Mutable)this);
        this._target.deepMap(mf);
        this._args.deepMap(mf);
    }

    public void forall(CategoryFcn f) {
        f.forall((Category)this);
        this._target.forall(f);
    }

    public void unifyCheck(Object u) throws UnifyFailure {
    }

    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        if (u instanceof CurriedCat) {
            CurriedCat cc = (CurriedCat)u;
            if (this.arity() > cc.arity()) {
                return cc.unify(this, sub);
            }
            if (cc._args.containsDollarArg()) {
                cc._args.unify(this._args, sub);
            } else {
                this._args.unify(cc._args, sub);
            }
            GUnifier.unify(this._target, cc._target, sub);
            return this.copy();
        }
        throw new UnifyFailure();
    }

    public boolean occurs(Variable v) {
        return this._target.occurs(v) || this._args.occurs(v);
    }

    public Object fill(Substitution s) throws UnifyFailure {
        Category $target = (Category)this._target.fill(s);
        if ($target instanceof TargetCat) {
            return new CurriedCat((TargetCat)$target, this._args.fill(s));
        }
        if ($target instanceof CurriedCat) {
            ((CurriedCat)$target).add(this._args.fill(s));
            return $target;
        }
        throw new UnifyFailure();
    }

    public boolean equals(Object c) {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._target.toString()).append(this._args.toString());
        return sb.toString();
    }
}

