#!/usr/bin/perl

package eBay::API::XML::DataType::BuyerRequirementDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BuyerRequirementDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BuyerRequirementDetailsType

=head1 DESCRIPTION

New Container for all buyer requirements in listing calls.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BuyerRequirementDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::MaximumBuyerPolicyViolationsType;
use eBay::API::XML::DataType::MaximumItemRequirementsType;
use eBay::API::XML::DataType::MaximumUnpaidItemStrikesInfoType;
use eBay::API::XML::DataType::VerifiedUserRequirementsType;


my @gaProperties = ( [ 'LinkedPayPalAccount', 'xs:boolean', '', '', '' ]
	, [ 'MaximumBuyerPolicyViolations', 'ns:MaximumBuyerPolicyViolationsType', ''
	     ,'eBay::API::XML::DataType::MaximumBuyerPolicyViolationsType', '1' ]
	, [ 'MaximumItemRequirements', 'ns:MaximumItemRequirementsType', ''
	     ,'eBay::API::XML::DataType::MaximumItemRequirementsType', '1' ]
	, [ 'MaximumUnpaidItemStrikesInfo', 'ns:MaximumUnpaidItemStrikesInfoType', ''
	     ,'eBay::API::XML::DataType::MaximumUnpaidItemStrikesInfoType', '1' ]
	, [ 'MinimumFeedbackScore', 'xs:int', '', '', '' ]
	, [ 'ShipToRegistrationCountry', 'xs:boolean', '', '', '' ]
	, [ 'VerifiedUserRequirements', 'ns:VerifiedUserRequirementsType', ''
	     ,'eBay::API::XML::DataType::VerifiedUserRequirementsType', '1' ]
	, [ 'ZeroFeedbackScore', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setLinkedPayPalAccount()

If true, only bidders with PayPal accounts linked to eBay may bid.
This field can be returned even if the caller is not the seller.
For AddItem, the seller's My eBay preference is automatically used with
request version 453 and greater. For lower request versions, you must send in explicit BuyerRequirement input even if you have your
"global" My eBay preference set to require this.

Default: false

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setLinkedPayPalAccount {
  my $self = shift;
  $self->{'LinkedPayPalAccount'} = shift
}

=head2 isLinkedPayPalAccount()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLinkedPayPalAccount {
  my $self = shift;
  return $self->{'LinkedPayPalAccount'};
}


=head2 setMaximumBuyerPolicyViolations()

If provided, blocks bidders who have received maximum allowed buyer 
policy violation reports from the sellers in the pre defined duration.

Default: false

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:MaximumBuyerPolicyViolationsType'

=cut

sub setMaximumBuyerPolicyViolations {
  my $self = shift;
  $self->{'MaximumBuyerPolicyViolations'} = shift
}

=head2 getMaximumBuyerPolicyViolations()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:MaximumBuyerPolicyViolationsType'

=cut

sub getMaximumBuyerPolicyViolations {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MaximumBuyerPolicyViolations'
		,'eBay::API::XML::DataType::MaximumBuyerPolicyViolationsType');
}


=head2 setMaximumItemRequirements()

A means of limiting unpaying, low feedback bidders.
Ignored as input if the application uses version 451 or older.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:MaximumItemRequirementsType'

=cut

sub setMaximumItemRequirements {
  my $self = shift;
  $self->{'MaximumItemRequirements'} = shift
}

=head2 getMaximumItemRequirements()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:MaximumItemRequirementsType'

=cut

sub getMaximumItemRequirements {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MaximumItemRequirements'
		,'eBay::API::XML::DataType::MaximumItemRequirementsType');
}


=head2 setMaximumUnpaidItemStrikesInfo()

If provided, blocks bidders who have received maximum unpaid item
strikes in the pre defined duration by the seller.

Default: false

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:MaximumUnpaidItemStrikesInfoType'

=cut

sub setMaximumUnpaidItemStrikesInfo {
  my $self = shift;
  $self->{'MaximumUnpaidItemStrikesInfo'} = shift
}

=head2 getMaximumUnpaidItemStrikesInfo()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:MaximumUnpaidItemStrikesInfoType'

=cut

sub getMaximumUnpaidItemStrikesInfo {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MaximumUnpaidItemStrikesInfo'
		,'eBay::API::XML::DataType::MaximumUnpaidItemStrikesInfoType');
}


=head2 setMinimumFeedbackScore()

If true, blocks bidders with this feedback score or lower.
Ignored as input if the application uses version 451 or older.
Valid values: -3, -2, -1.

Max: Min: 
  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:int'

=cut

sub setMinimumFeedbackScore {
  my $self = shift;
  $self->{'MinimumFeedbackScore'} = shift
}

=head2 getMinimumFeedbackScore()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:int'

=cut

sub getMinimumFeedbackScore {
  my $self = shift;
  return $self->{'MinimumFeedbackScore'};
}


=head2 setShipToRegistrationCountry()

If true, blocks bidders who are registered in countries to which
the seller has specified he will not shipo.
Ignored as input if the application uses version 451 or older.

Default: false

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setShipToRegistrationCountry {
  my $self = shift;
  $self->{'ShipToRegistrationCountry'} = shift
}

=head2 isShipToRegistrationCountry()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isShipToRegistrationCountry {
  my $self = shift;
  return $self->{'ShipToRegistrationCountry'};
}


=head2 setVerifiedUserRequirements()

A means of limiting unverified bidders.
Ignored as input if the application uses version 451 or older.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:VerifiedUserRequirementsType'

=cut

sub setVerifiedUserRequirements {
  my $self = shift;
  $self->{'VerifiedUserRequirements'} = shift
}

=head2 getVerifiedUserRequirements()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'ns:VerifiedUserRequirementsType'

=cut

sub getVerifiedUserRequirements {
  my $self = shift;
  return $self->_getDataTypeInstance( 'VerifiedUserRequirements'
		,'eBay::API::XML::DataType::VerifiedUserRequirementsType');
}


=head2 setZeroFeedbackScore()

If true, blocks bidders with a feedback score of 0 who attempt to bid on
Buy It Now items worth 100 RMB or more.
Ignored as input if the application uses version 451 or older.
This requirement is only enabled for the CN site.

Default: false

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setZeroFeedbackScore {
  my $self = shift;
  $self->{'ZeroFeedbackScore'} = shift
}

=head2 isZeroFeedbackScore()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isZeroFeedbackScore {
  my $self = shift;
  return $self->{'ZeroFeedbackScore'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
