# Generated by default/object.tt
package Paws::ES::AutoTuneOptions;
  use Moose;
  has DesiredState => (is => 'ro', isa => 'Str');
  has MaintenanceSchedules => (is => 'ro', isa => 'ArrayRef[Paws::ES::AutoTuneMaintenanceSchedule]');
  has RollbackOnDisable => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ES::AutoTuneOptions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ES::AutoTuneOptions object:

  $service_obj->Method(Att1 => { DesiredState => $value, ..., RollbackOnDisable => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ES::AutoTuneOptions object:

  $result = $service_obj->Method(...);
  $result->Att1->DesiredState

=head1 DESCRIPTION

Specifies the Auto-Tune options: the Auto-Tune desired state for the
domain, rollback state when disabling Auto-Tune options and list of
maintenance schedules.

=head1 ATTRIBUTES


=head2 DesiredState => Str

Specifies the Auto-Tune desired state. Valid values are ENABLED,
DISABLED.


=head2 MaintenanceSchedules => ArrayRef[L<Paws::ES::AutoTuneMaintenanceSchedule>]

Specifies list of maitenance schedules. See the Developer Guide
(https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html)
for more information.


=head2 RollbackOnDisable => Str

Specifies the rollback state while disabling Auto-Tune for the domain.
Valid values are NO_ROLLBACK, DEFAULT_ROLLBACK.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

