# Generated by default/object.tt
package Paws::GlobalAccelerator::DestinationPortMapping;
  use Moose;
  has AcceleratorArn => (is => 'ro', isa => 'Str');
  has AcceleratorSocketAddresses => (is => 'ro', isa => 'ArrayRef[Paws::GlobalAccelerator::SocketAddress]');
  has DestinationSocketAddress => (is => 'ro', isa => 'Paws::GlobalAccelerator::SocketAddress');
  has DestinationTrafficState => (is => 'ro', isa => 'Str');
  has EndpointGroupArn => (is => 'ro', isa => 'Str');
  has EndpointGroupRegion => (is => 'ro', isa => 'Str');
  has EndpointId => (is => 'ro', isa => 'Str');
  has IpAddressType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlobalAccelerator::DestinationPortMapping

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlobalAccelerator::DestinationPortMapping object:

  $service_obj->Method(Att1 => { AcceleratorArn => $value, ..., IpAddressType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlobalAccelerator::DestinationPortMapping object:

  $result = $service_obj->Method(...);
  $result->Att1->AcceleratorArn

=head1 DESCRIPTION

The port mappings for a specified endpoint IP address (destination).

=head1 ATTRIBUTES


=head2 AcceleratorArn => Str

The Amazon Resource Name (ARN) of the custom routing accelerator that
you have port mappings for.


=head2 AcceleratorSocketAddresses => ArrayRef[L<Paws::GlobalAccelerator::SocketAddress>]

The IP address/port combinations (sockets) that map to a given
destination socket address.


=head2 DestinationSocketAddress => L<Paws::GlobalAccelerator::SocketAddress>

The endpoint IP address/port combination for traffic received on the
accelerator socket address.


=head2 DestinationTrafficState => Str

Indicates whether or not a port mapping destination can receive
traffic. The value is either ALLOW, if traffic is allowed to the
destination, or DENY, if traffic is not allowed to the destination.


=head2 EndpointGroupArn => Str

The Amazon Resource Name (ARN) of the endpoint group.


=head2 EndpointGroupRegion => Str

The AWS Region for the endpoint group.


=head2 EndpointId => Str

The ID for the virtual private cloud (VPC) subnet.


=head2 IpAddressType => Str

The IP address type, which must be IPv4.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlobalAccelerator>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

