package VM::HetznerCloud::API::Certificates;

# ABSTRACT: Certificates

# ---
# This class is auto-generated by bin/get_hetzner_info.pl
# ---

use v5.24;

use Moo;
use Types::Standard qw(:all);

use Mojo::Base -strict, -signatures;

extends 'VM::HetznerCloud::APIBase';

our $VERSION = '0.0.2'; # VERSION

has endpoint  => ( is => 'ro', isa => Str, default => sub { 'certificates' } );

sub list ($self, %params) {
    my $request_params = {
        'label_selector' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
        'name' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
        'sort' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
        'type' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
    };
;
    return $self->_request( '', \%params, $request_params, { type => 'get' } );
}

sub create ($self, %params) {
    my $request_params = {};
    return $self->_request( '', \%params, $request_params, { type => 'post' } );
}

sub delete ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };
;
    return $self->_request( '/:id', \%params, $request_params, { type => 'delete' } );
}

sub get ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };
;
    return $self->_request( '/:id', \%params, $request_params, { type => 'get' } );
}

sub put ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };
;
    return $self->_request( '/:id', \%params, $request_params, { type => 'put' } );
}

sub list_actions ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
        'sort' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
        'status' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
    };
;
    return $self->_request( '/:id/actions', \%params, $request_params, { type => 'get' } );
}

sub retry ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };
;
    return $self->_request( '/:id/actions/retry', \%params, $request_params, { type => 'post' } );
}

sub get_actions ($self, %params) {
    my $request_params = {
        'action_id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };
;
    return $self->_request( '/:id/actions/:action_id', \%params, $request_params, { type => 'get' } );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

VM::HetznerCloud::API::Certificates - Certificates

=head1 VERSION

version 0.0.2

=head1 SYNOPSIS

    use VM::HetznerCloud;

    my $api_key = '1234abc';
    my $cloud   = VM::HetznerCloud->new(
        token => $api_key,
    );

    $cloud->records->create(
    );

=head1 ATTRIBUTES

=over 4

=item * endpoint

=back

=head1 METHODS

=head2 list

Returns all Certificate objects.

    $cloud->certificates->list(
        label_selector => 'test',
        name => 'test',
        sort => 'test',
        type => 'test',
    );

=head2 create

Creates a new Certificate.

The default type **uploaded** allows for uploading your existing `certificate` and `private_key` in PEM format. You have to monitor its expiration date and handle renewal yourself.

In contrast, type **managed** requests a new Certificate from *Let's Encrypt* for the specified `domain_names`. Only domains managed by *Hetzner DNS* are supported. We handle renewal and timely alert the project owner via email if problems occur.

For type `managed` Certificates the `action` key of the response contains the Action that allows for tracking the issuance process. For type `uploaded` Certificates the `action` is always null.

    $cloud->certificates->create();

=head2 delete

Deletes a Certificate.

    $cloud->certificates->delete(
        id => 'test',
    );

=head2 get

Gets a specific Certificate object.

    $cloud->certificates->get(
        id => 'test',
    );

=head2 put

Updates the Certificate properties.

Note that when updating labels, the Certificate’s current set of labels will be replaced with the labels provided in the request body. So, for example, if you want to add a new label, you have to provide all existing labels plus the new label in the request body.

Note: if the Certificate object changes during the request, the response will be a “conflict” error.

    $cloud->certificates->put(
        id => 'test',
    );

=head2 list_actions

Returns all Action objects for a Certificate. You can sort the results by using the `sort` URI parameter, and filter them with the `status` parameter.

Only type `managed` Certificates can have Actions. For type `uploaded` Certificates the `actions` key will always contain an empty array.

    $cloud->certificates->list_actions(
        id => 'test',
        sort => 'test',
        status => 'test',
    );

=head2 retry

Retry a failed Certificate issuance or renewal.

Only applicable if the type of the Certificate is `managed` and the issuance or renewal status is `failed`.

#### Call specific error codes

| Code                                                    | Description                                                               |
|---------------------------------------------------------|---------------------------------------------------------------------------|
| `caa_record_does_not_allow_ca`                          | CAA record does not allow certificate authority                           |
| `ca_dns_validation_failed`                              | Certificate Authority: DNS validation failed                              |
| `ca_too_many_authorizations_failed_recently`            | Certificate Authority: Too many authorizations failed recently            |
| `ca_too_many_certificates_issued_for_registered_domain` | Certificate Authority: Too many certificates issued for registered domain |
| `ca_too_many_duplicate_certificates`                    | Certificate Authority: Too many duplicate certificates                    |
| `could_not_verify_domain_delegated_to_zone`             | Could not verify domain delegated to zone                                 |
| `dns_zone_not_found`                                    | DNS zone not found                                                        |
| `dns_zone_is_secondary_zone`                            | DNS zone is a secondary zone                                              |

    $cloud->certificates->retry(
        id => 'test',
    );

=head2 get_actions

Returns a specific Action for a Certificate. Only type `managed` Certificates have Actions.

    $cloud->certificates->get_actions(
        action_id => 'test',
        id => 'test',
    );

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
