/* 
 * encode_base64ufs.c - test RFC 3548 encodings
 *
 * Copyright (C) 2005 Yann Droneaud <ydroneaud@meuh.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <assert.h>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include "encoding3548.h"

int
main(int argc, char **argv)
{
  FILE *f;
  
  char *encode_buffer;
  
  char file_buffer[256];
  
  ssize_t len;

  f = fopen(argv[1], "r");
  if (f == NULL) {
    fprintf(stderr, "Can't open test file '%s': %s\n", argv[1], strerror(errno));
    return 1;
  }
  
  len = fread(file_buffer, 1, 256, f);
    
  /* No input data more than 256 byte */
  assert(feof(f));

  fclose(f);

  encode_buffer = (char *) malloc(base64_encode_len(len) + 1);
  
  base64_ufs_encode(encode_buffer, file_buffer, len);
  encode_buffer[base64_encode_len(len)] = '\0';
  
  printf("%s\n", encode_buffer);
  
  free(encode_buffer);
  
  return 0;
}
