## Copyright (C) 2007 Muthiah Annamalai <muthiah.annamalai@mavs.uta.edu>
##
## This program is free software; you can redistribute it and/or modify it under
## the terms of the GNU General Public License as published by the Free Software
## Foundation; either version 3 of the License, or (at your option) any later
## version.
##
## This program is distributed in the hope that it will be useful, but WITHOUT
## ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
## FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
## details.
##
## You should have received a copy of the GNU General Public License along with
## this program; if not, see <http://www.gnu.org/licenses/>.

## -*- texinfo -*-
## @deftypefn {Function File} {@var{coefs}=} hermitepoly (@var{order},@var{x})
## 
## Compute the coefficients of the Hermite polynomial, given the 
## @var{order}. We calculate the Hermite polynomial using the recurrence
## relations, Hn+1(x) = 2x.Hn(x) - 2nHn-1(x).
## 
## If the value @var{x} is specified, the polynomial is also evaluated,
## otherwise just the return the coefficients.
## 
## @end deftypefn

function h = hermitepoly (order, val)
  if nargin < 1, print_usage, end
  
  ## contains the first 50 hermite-polynomials
  H = [ 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 2.00000000e+00 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 4.00000000e+00 0.00000000e+00 -2.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 8.00000000e+00 0.00000000e+00 -1.20000000e+01 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.60000000e+01 0.00000000e+00 -4.80000000e+01 0.00000000e+00 1.20000000e+01
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 3.20000000e+01 0.00000000e+00 -1.60000000e+02 0.00000000e+00 1.20000000e+02 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 6.40000000e+01 0.00000000e+00 -4.80000000e+02 0.00000000e+00 7.20000000e+02 0.00000000e+00 -1.20000000e+02
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.28000000e+02 0.00000000e+00 -1.34400000e+03 0.00000000e+00 3.36000000e+03 0.00000000e+00 -1.68000000e+03 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 2.56000000e+02 0.00000000e+00 -3.58400000e+03 0.00000000e+00 1.34400000e+04 0.00000000e+00 -1.34400000e+04 0.00000000e+00 1.68000000e+03
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 5.12000000e+02 0.00000000e+00 -9.21600000e+03 0.00000000e+00 4.83840000e+04 0.00000000e+00 -8.06400000e+04 0.00000000e+00 3.02400000e+04 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.02400000e+03 0.00000000e+00 -2.30400000e+04 0.00000000e+00 1.61280000e+05 0.00000000e+00 -4.03200000e+05 0.00000000e+00 3.02400000e+05 0.00000000e+00 -3.02400000e+04
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 2.04800000e+03 0.00000000e+00 -5.63200000e+04 0.00000000e+00 5.06880000e+05 0.00000000e+00 -1.77408000e+06 0.00000000e+00 2.21760000e+06 0.00000000e+00 -6.65280000e+05 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 4.09600000e+03 0.00000000e+00 -1.35168000e+05 0.00000000e+00 1.52064000e+06 0.00000000e+00 -7.09632000e+06 0.00000000e+00 1.33056000e+07 0.00000000e+00 -7.98336000e+06 0.00000000e+00 6.65280000e+05
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 8.19200000e+03 0.00000000e+00 -3.19488000e+05 0.00000000e+00 4.39296000e+06 0.00000000e+00 -2.63577600e+07 0.00000000e+00 6.91891200e+07 0.00000000e+00 -6.91891200e+07 0.00000000e+00 1.72972800e+07 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.63840000e+04 0.00000000e+00 -7.45472000e+05 0.00000000e+00 1.23002880e+07 0.00000000e+00 -9.22521600e+07 0.00000000e+00 3.22882560e+08 0.00000000e+00 -4.84323840e+08 0.00000000e+00 2.42161920e+08 0.00000000e+00 -1.72972800e+07
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 3.27680000e+04 0.00000000e+00 -1.72032000e+06 0.00000000e+00 3.35462400e+07 0.00000000e+00 -3.07507200e+08 0.00000000e+00 1.38378240e+09 0.00000000e+00 -2.90594304e+09 0.00000000e+00 2.42161920e+09 0.00000000e+00 -5.18918400e+08 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 6.55360000e+04 0.00000000e+00 -3.93216000e+06 0.00000000e+00 8.94566400e+07 0.00000000e+00 -9.84023040e+08 0.00000000e+00 5.53512960e+09 0.00000000e+00 -1.54983629e+10 0.00000000e+00 1.93729536e+10 0.00000000e+00 -8.30269440e+09 0.00000000e+00 5.18918400e+08
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.31072000e+05 0.00000000e+00 -8.91289600e+06 0.00000000e+00 2.33963520e+08 0.00000000e+00 -3.04152576e+09 0.00000000e+00 2.09104896e+10 0.00000000e+00 -7.52777626e+10 0.00000000e+00 1.31736084e+11 0.00000000e+00 -9.40972032e+10 0.00000000e+00 1.76432256e+10 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 2.62144000e+05 0.00000000e+00 -2.00540160e+07 0.00000000e+00 6.01620480e+08 0.00000000e+00 -9.12457728e+09 0.00000000e+00 7.52777626e+10 0.00000000e+00 -3.38749932e+11 0.00000000e+00 7.90416507e+11 0.00000000e+00 -8.46874829e+11 0.00000000e+00 3.17578061e+11 0.00000000e+00 -1.76432256e+10
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 5.24288000e+05 0.00000000e+00 -4.48266240e+07 0.00000000e+00 1.52410522e+09 0.00000000e+00 -2.66718413e+10 0.00000000e+00 2.60050452e+11 0.00000000e+00 -1.43027749e+12 0.00000000e+00 4.29083247e+12 0.00000000e+00 -6.43624870e+12 0.00000000e+00 4.02265544e+12 0.00000000e+00 -6.70442573e+11 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.04857600e+06 0.00000000e+00 -9.96147200e+07 0.00000000e+00 3.81026304e+09 0.00000000e+00 -7.62052608e+10 0.00000000e+00 8.66834842e+11 0.00000000e+00 -5.72110995e+12 0.00000000e+00 2.14541623e+13 0.00000000e+00 -4.29083247e+13 0.00000000e+00 4.02265544e+13 0.00000000e+00 -1.34088515e+13 0.00000000e+00 6.70442573e+11
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 2.09715200e+06 0.00000000e+00 -2.20200960e+08 0.00000000e+00 9.41359104e+09 0.00000000e+00 -2.13374730e+11 0.00000000e+00 2.80054333e+12 0.00000000e+00 -2.18442380e+13 0.00000000e+00 1.00119424e+14 0.00000000e+00 -2.57449948e+14 0.00000000e+00 3.37903057e+14 0.00000000e+00 -1.87723920e+14 0.00000000e+00 2.81585881e+13 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 4.19430400e+06 0.00000000e+00 -4.84442112e+08 0.00000000e+00 2.30110003e+10 0.00000000e+00 -5.86780508e+11 0.00000000e+00 8.80170762e+12 0.00000000e+00 -8.00955394e+13 0.00000000e+00 4.40525467e+14 0.00000000e+00 -1.41597471e+15 0.00000000e+00 2.47795575e+15 0.00000000e+00 -2.06496312e+15 0.00000000e+00 6.19488937e+14 0.00000000e+00 -2.81585881e+13
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 8.38860800e+06 0.00000000e+00 -1.06115891e+09 0.00000000e+00 5.57108429e+10 0.00000000e+00 -1.58775902e+12 0.00000000e+00 2.69919034e+13 0.00000000e+00 -2.83414985e+14 0.00000000e+00 1.84219741e+15 0.00000000e+00 -7.23720409e+15 0.00000000e+00 1.62837092e+16 0.00000000e+00 -1.89976607e+16 0.00000000e+00 9.49883037e+15 0.00000000e+00 -1.29529505e+15 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.67772160e+07 0.00000000e+00 -2.31525581e+09 0.00000000e+00 1.33706023e+11 0.00000000e+00 -4.23402406e+12 0.00000000e+00 8.09757101e+13 0.00000000e+00 -9.71708522e+14 0.00000000e+00 7.36878962e+15 0.00000000e+00 -3.47385796e+16 0.00000000e+00 9.77022552e+16 0.00000000e+00 -1.51981286e+17 0.00000000e+00 1.13985964e+17 0.00000000e+00 -3.10870812e+16 0.00000000e+00 1.29529505e+15
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 3.35544320e+07 0.00000000e+00 -5.03316480e+09 0.00000000e+00 3.18347674e+11 0.00000000e+00 -1.11421686e+13 0.00000000e+00 2.38163853e+14 0.00000000e+00 -3.23902841e+15 0.00000000e+00 2.83414985e+16 0.00000000e+00 -1.57902635e+17 0.00000000e+00 5.42790307e+17 0.00000000e+00 -1.08558061e+18 0.00000000e+00 1.13985964e+18 0.00000000e+00 -5.18118020e+17 0.00000000e+00 6.47647525e+16 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 6.71088640e+07 0.00000000e+00 -1.09051904e+10 0.00000000e+00 7.52458138e+11 0.00000000e+00 -2.89696383e+13 0.00000000e+00 6.88028910e+14 0.00000000e+00 -1.05268423e+16 0.00000000e+00 1.05268423e+17 0.00000000e+00 -6.84244751e+17 0.00000000e+00 2.82250960e+18 0.00000000e+00 -7.05627399e+18 0.00000000e+00 9.87878359e+18 0.00000000e+00 -6.73553426e+18 0.00000000e+00 1.68388357e+18 0.00000000e+00 -6.47647525e+16
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.34217728e+08 0.00000000e+00 -2.35552113e+10 0.00000000e+00 1.76664084e+12 0.00000000e+00 -7.44933556e+13 0.00000000e+00 1.95545059e+15 0.00000000e+00 -3.34382050e+16 0.00000000e+00 3.78966323e+17 0.00000000e+00 -2.84224743e+18 0.00000000e+00 1.38559562e+19 0.00000000e+00 -4.23376439e+19 0.00000000e+00 7.62077591e+19 0.00000000e+00 -7.27437700e+19 0.00000000e+00 3.03099042e+19 0.00000000e+00 -3.49729664e+18 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 2.68435456e+08 0.00000000e+00 -5.07343012e+10 0.00000000e+00 4.12216197e+12 0.00000000e+00 -1.89619451e+14 0.00000000e+00 5.47526164e+15 0.00000000e+00 -1.04029971e+17 0.00000000e+00 1.32638213e+18 0.00000000e+00 -1.13689897e+19 0.00000000e+00 6.46611289e+19 0.00000000e+00 -2.37090806e+20 0.00000000e+00 5.33454314e+20 0.00000000e+00 -6.78941854e+20 0.00000000e+00 4.24338659e+20 0.00000000e+00 -9.79243058e+19 0.00000000e+00 3.49729664e+18
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 5.36870912e+08 0.00000000e+00 -1.08984795e+11 0.00000000e+00 9.56341577e+12 0.00000000e+00 -4.78170789e+14 0.00000000e+00 1.51221512e+16 0.00000000e+00 -3.17565175e+17 0.00000000e+00 4.52530374e+18 0.00000000e+00 -4.39600935e+19 0.00000000e+00 2.88488114e+20 0.00000000e+00 -1.25011516e+21 0.00000000e+00 3.43781669e+21 0.00000000e+00 -5.62551822e+21 0.00000000e+00 4.92232844e+21 0.00000000e+00 -1.89320325e+21 0.00000000e+00 2.02843205e+20 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.07374182e+09 0.00000000e+00 -2.33538847e+11 0.00000000e+00 2.20694210e+13 0.00000000e+00 -1.19542697e+15 0.00000000e+00 4.12422305e+16 0.00000000e+00 -9.52695525e+17 0.00000000e+00 1.50843458e+19 0.00000000e+00 -1.64850351e+20 0.00000000e+00 1.23637763e+21 0.00000000e+00 -6.25057580e+21 0.00000000e+00 2.06269001e+22 0.00000000e+00 -4.21913866e+22 0.00000000e+00 4.92232844e+22 0.00000000e+00 -2.83980487e+22 0.00000000e+00 6.08529615e+21 0.00000000e+00 -2.02843205e+20
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 2.14748365e+09 0.00000000e+00 -4.99289948e+11 0.00000000e+00 5.06779297e+13 0.00000000e+00 -2.96465889e+15 0.00000000e+00 1.11174708e+17 0.00000000e+00 -2.81272012e+18 0.00000000e+00 4.92226021e+19 0.00000000e+00 -6.01218926e+20 0.00000000e+00 5.11036087e+21 0.00000000e+00 -2.98104384e+22 0.00000000e+00 1.16260710e+23 0.00000000e+00 -2.90651775e+23 0.00000000e+00 4.35977662e+23 0.00000000e+00 -3.52135804e+23 0.00000000e+00 1.25762787e+23 0.00000000e+00 -1.25762787e+22 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 4.29496730e+09 0.00000000e+00 -1.06515189e+12 0.00000000e+00 1.15835268e+14 0.00000000e+00 -7.29762188e+15 0.00000000e+00 2.96465889e+17 0.00000000e+00 -8.18245854e+18 0.00000000e+00 1.57512327e+20 0.00000000e+00 -2.13766729e+21 0.00000000e+00 2.04414435e+22 0.00000000e+00 -1.36276290e+23 0.00000000e+00 6.20057119e+23 0.00000000e+00 -1.86017136e+24 0.00000000e+00 3.48782129e+24 0.00000000e+00 -3.75611524e+24 0.00000000e+00 2.01220459e+24 0.00000000e+00 -4.02440919e+23 0.00000000e+00 1.25762787e+22
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 8.58993459e+09 0.00000000e+00 -2.26774273e+12 0.00000000e+00 2.63625093e+14 0.00000000e+00 -1.78386313e+16 0.00000000e+00 7.82669947e+17 0.00000000e+00 -2.34800984e+19 0.00000000e+00 4.95038741e+20 0.00000000e+00 -7.42558112e+21 0.00000000e+00 7.93608982e+22 0.00000000e+00 -5.99615676e+23 0.00000000e+00 3.14798230e+24 0.00000000e+00 -1.11610281e+25 0.00000000e+00 2.55773562e+25 0.00000000e+00 -3.54148008e+25 0.00000000e+00 2.65611006e+25 0.00000000e+00 -8.85370021e+24 0.00000000e+00 8.30034395e+23 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.71798692e+10 0.00000000e+00 -4.81895331e+12 0.00000000e+00 5.97550210e+14 0.00000000e+00 -4.33223902e+16 0.00000000e+00 2.04698294e+18 0.00000000e+00 -6.65269455e+19 0.00000000e+00 1.53011975e+21 0.00000000e+00 -2.52469758e+22 0.00000000e+00 2.99807838e+23 0.00000000e+00 -2.54836662e+24 0.00000000e+00 1.52901997e+25 0.00000000e+00 -6.32458261e+25 0.00000000e+00 1.73926022e+26 0.00000000e+00 -3.01025807e+26 0.00000000e+00 3.01025807e+26 0.00000000e+00 -1.50512904e+26 0.00000000e+00 2.82211694e+25 0.00000000e+00 -8.30034395e+23
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 3.43597384e+10 0.00000000e+00 -1.02220222e+13 0.00000000e+00 1.34930693e+15 0.00000000e+00 -1.04571287e+17 0.00000000e+00 5.30699280e+18 0.00000000e+00 -1.86275447e+20 0.00000000e+00 4.65688618e+21 0.00000000e+00 -8.41565860e+22 0.00000000e+00 1.10455519e+24 0.00000000e+00 -1.04932743e+25 0.00000000e+00 7.13542654e+25 0.00000000e+00 -3.40554448e+26 0.00000000e+00 1.10680196e+27 0.00000000e+00 -2.34131183e+27 0.00000000e+00 3.01025807e+27 0.00000000e+00 -2.10718065e+27 0.00000000e+00 6.58493953e+26 0.00000000e+00 -5.81024076e+25 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 6.87194767e+10 0.00000000e+00 -2.16466352e+13 0.00000000e+00 3.03594058e+15 0.00000000e+00 -2.50971088e+17 0.00000000e+00 1.36465529e+19 0.00000000e+00 -5.15839700e+20 0.00000000e+00 1.39706586e+22 0.00000000e+00 -2.75421554e+23 0.00000000e+00 3.97639869e+24 0.00000000e+00 -4.19730973e+25 0.00000000e+00 3.21094194e+26 0.00000000e+00 -1.75142288e+27 0.00000000e+00 6.64081174e+27 0.00000000e+00 -1.68574452e+28 0.00000000e+00 2.70923226e+28 0.00000000e+00 -2.52861678e+28 0.00000000e+00 1.18528912e+28 0.00000000e+00 -2.09168667e+27 0.00000000e+00 5.81024076e+25
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.37438953e+11 0.00000000e+00 -4.57671715e+13 0.00000000e+00 6.80786676e+15 0.00000000e+00 -5.99092275e+17 0.00000000e+00 3.48222385e+19 0.00000000e+00 -1.41378288e+21 0.00000000e+00 4.13531493e+22 0.00000000e+00 -8.86138914e+23 0.00000000e+00 1.40120716e+25 0.00000000e+00 -1.63474168e+26 0.00000000e+00 1.39770414e+27 0.00000000e+00 -8.64035286e+27 0.00000000e+00 3.78015438e+28 0.00000000e+00 -1.13404631e+29 0.00000000e+00 2.22759097e+29 0.00000000e+00 -2.67310917e+29 0.00000000e+00 1.75422789e+29 0.00000000e+00 -5.15949380e+28 0.00000000e+00 4.29957816e+27 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 2.74877907e+11 0.00000000e+00 -9.66195843e+13 0.00000000e+00 1.52175845e+16 0.00000000e+00 -1.42284415e+18 0.00000000e+00 8.82163375e+19 0.00000000e+00 -3.83741068e+21 0.00000000e+00 1.20878436e+23 0.00000000e+00 -2.80610656e+24 0.00000000e+00 4.84053382e+25 0.00000000e+00 -6.21201840e+26 0.00000000e+00 5.90141748e+27 0.00000000e+00 -4.10416761e+28 0.00000000e+00 2.05208381e+29 0.00000000e+00 -7.18229332e+29 0.00000000e+00 1.69296914e+30 0.00000000e+00 -2.53945371e+30 0.00000000e+00 2.22202200e+30 0.00000000e+00 -9.80303821e+29 0.00000000e+00 1.63383970e+29 0.00000000e+00 -4.29957816e+27
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 5.49755814e+11 0.00000000e+00 -2.03684529e+14 0.00000000e+00 3.39134741e+16 0.00000000e+00 -3.36308618e+18 0.00000000e+00 2.21963688e+20 0.00000000e+00 -1.03213115e+22 0.00000000e+00 3.49204372e+23 0.00000000e+00 -8.75505247e+24 0.00000000e+00 1.64157234e+26 0.00000000e+00 -2.30732112e+27 0.00000000e+00 2.42268718e+28 0.00000000e+00 -1.88308867e+29 0.00000000e+00 1.06708358e+30 0.00000000e+00 -4.30937599e+30 0.00000000e+00 1.20046903e+31 0.00000000e+00 -2.20085988e+31 0.00000000e+00 2.47596737e+31 0.00000000e+00 -1.52927396e+31 0.00000000e+00 4.24798323e+30 0.00000000e+00 -3.35367097e+29 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.09951163e+12 0.00000000e+00 -4.28809535e+14 0.00000000e+00 7.53632757e+16 0.00000000e+00 -7.91314395e+18 0.00000000e+00 5.54909220e+20 0.00000000e+00 -2.75234973e+22 0.00000000e+00 9.97726777e+23 0.00000000e+00 -2.69386230e+25 0.00000000e+00 5.47190779e+26 0.00000000e+00 -8.39025862e+27 0.00000000e+00 9.69074870e+28 0.00000000e+00 -8.36928297e+29 0.00000000e+00 5.33541789e+30 0.00000000e+00 -2.46250057e+31 0.00000000e+00 8.00312684e+31 0.00000000e+00 -1.76068790e+32 0.00000000e+00 2.47596737e+32 0.00000000e+00 -2.03903195e+32 0.00000000e+00 8.49596645e+31 0.00000000e+00 -1.34146839e+31 0.00000000e+00 3.35367097e+29
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 2.19902326e+12 0.00000000e+00 -9.01599535e+14 0.00000000e+00 1.67021314e+17 0.00000000e+00 -1.85393658e+19 0.00000000e+00 1.37886533e+21 0.00000000e+00 -7.28040896e+22 0.00000000e+00 2.82115847e+24 0.00000000e+00 -8.18135957e+25 0.00000000e+00 1.79478576e+27 0.00000000e+00 -2.99130959e+28 0.00000000e+00 3.78400664e+29 0.00000000e+00 -3.61200633e+30 0.00000000e+00 2.57355451e+31 0.00000000e+00 -1.34616698e+32 0.00000000e+00 5.04812616e+32 0.00000000e+00 -1.31251280e+33 0.00000000e+00 2.25588138e+33 0.00000000e+00 -2.38858028e+33 0.00000000e+00 1.39333850e+33 0.00000000e+00 -3.66668026e+32 0.00000000e+00 2.75001019e+31 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 4.39804651e+12 0.00000000e+00 -1.89335902e+15 0.00000000e+00 3.69205009e+17 0.00000000e+00 -4.32585203e+19 0.00000000e+00 3.40660847e+21 0.00000000e+00 -1.91110735e+23 0.00000000e+00 7.89924372e+24 0.00000000e+00 -2.45440787e+26 0.00000000e+00 5.79853860e+27 0.00000000e+00 -1.04695836e+29 0.00000000e+00 1.44480253e+30 0.00000000e+00 -1.51704266e+31 0.00000000e+00 1.20099211e+32 0.00000000e+00 -7.06737662e+32 0.00000000e+00 3.02887570e+33 0.00000000e+00 -9.18758961e+33 0.00000000e+00 1.89494036e+34 0.00000000e+00 -2.50800930e+34 0.00000000e+00 1.95067390e+34 0.00000000e+00 -7.70002854e+33 0.00000000e+00 1.15500428e+33 0.00000000e+00 -2.75001019e+31
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 8.79609302e+12 0.00000000e+00 -3.97143600e+15 0.00000000e+00 8.14144380e+17 0.00000000e+00 -1.00546831e+20 0.00000000e+00 8.37052367e+21 0.00000000e+00 -4.98046159e+23 0.00000000e+00 2.19140310e+25 0.00000000e+00 -7.27858886e+26 0.00000000e+00 1.84694192e+28 0.00000000e+00 -3.60153675e+29 0.00000000e+00 5.40230513e+30 0.00000000e+00 -6.21265089e+31 0.00000000e+00 5.43606953e+32 0.00000000e+00 -3.57526112e+33 0.00000000e+00 1.73655540e+34 0.00000000e+00 -6.07794390e+34 0.00000000e+00 1.48149882e+35 0.00000000e+00 -2.39654222e+35 0.00000000e+00 2.39654222e+35 0.00000000e+00 -1.32440491e+35 0.00000000e+00 3.31101227e+34 0.00000000e+00 -2.36500877e+33 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.75921860e+13 0.00000000e+00 -8.32110400e+15 0.00000000e+00 1.79111764e+18 0.00000000e+00 -2.32845293e+20 0.00000000e+00 2.04612801e+22 0.00000000e+00 -1.28906065e+24 0.00000000e+00 6.02635852e+25 0.00000000e+00 -2.13505273e+27 0.00000000e+00 5.80467462e+28 0.00000000e+00 -1.21898167e+30 0.00000000e+00 1.98084521e+31 0.00000000e+00 -2.48506036e+32 0.00000000e+00 2.39187059e+33 0.00000000e+00 -1.74790543e+34 0.00000000e+00 9.55105470e+34 0.00000000e+00 -3.82042188e+35 0.00000000e+00 1.08643247e+36 0.00000000e+00 -2.10895715e+36 0.00000000e+00 2.63619644e+36 0.00000000e+00 -1.94246053e+36 0.00000000e+00 7.28422700e+35 0.00000000e+00 -1.04060386e+35 0.00000000e+00 2.36500877e+33
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 3.51843721e+13 0.00000000e+00 -1.74162642e+16 0.00000000e+00 3.93172164e+18 0.00000000e+00 -5.37335291e+20 0.00000000e+00 4.97706813e+22 0.00000000e+00 -3.31472737e+24 0.00000000e+00 1.64355232e+26 0.00000000e+00 -6.19854019e+27 0.00000000e+00 1.80145074e+29 0.00000000e+00 -4.06327223e+30 0.00000000e+00 7.13104277e+31 0.00000000e+00 -9.72414923e+32 0.00000000e+00 1.02508740e+34 0.00000000e+00 -8.27955206e+34 0.00000000e+00 5.05644072e+35 0.00000000e+00 -2.29225313e+36 0.00000000e+00 7.52145557e+36 0.00000000e+00 -1.72551040e+37 0.00000000e+00 2.63619644e+37 0.00000000e+00 -2.49744926e+37 0.00000000e+00 1.31116086e+37 0.00000000e+00 -3.12181157e+36 0.00000000e+00 2.12850789e+35 0.00000000e+00
 0.00000000e+00 0.00000000e+00 0.00000000e+00 0.00000000e+00 7.03687442e+13 0.00000000e+00 -3.64158251e+16 0.00000000e+00 8.61234264e+18 0.00000000e+00 -1.23587117e+21 0.00000000e+00 1.20497439e+23 0.00000000e+00 -8.47096996e+24 0.00000000e+00 4.44725923e+26 0.00000000e+00 -1.78208030e+28 0.00000000e+00 5.52444895e+29 0.00000000e+00 -1.33507516e+31 0.00000000e+00 2.52329206e+32 0.00000000e+00 -3.72759054e+33 0.00000000e+00 4.28672912e+34 0.00000000e+00 -3.80859395e+35 0.00000000e+00 2.58440304e+36 0.00000000e+00 -1.31804555e+37 0.00000000e+00 4.94267080e+37 0.00000000e+00 -1.32289130e+38 0.00000000e+00 2.42530072e+38 0.00000000e+00 -2.87206665e+38 0.00000000e+00 2.01044665e+38 0.00000000e+00 -7.18016662e+37 0.00000000e+00 9.79113629e+36 0.00000000e+00 -2.12850789e+35
 0.00000000e+00 0.00000000e+00 0.00000000e+00 1.40737488e+14 0.00000000e+00 -7.60686125e+16 0.00000000e+00 1.88269816e+19 0.00000000e+00 -2.83346073e+21 0.00000000e+00 2.90429725e+23 0.00000000e+00 -2.15208426e+25 0.00000000e+00 1.19440676e+27 0.00000000e+00 -5.07622875e+28 0.00000000e+00 1.67515549e+30 0.00000000e+00 -4.32748501e+31 0.00000000e+00 8.78479456e+32 0.00000000e+00 -1.40157404e+34 0.00000000e+00 1.75196755e+35 0.00000000e+00 -1.70479920e+36 0.00000000e+00 1.27859940e+37 0.00000000e+00 -7.28801656e+37 0.00000000e+00 3.09740704e+38 0.00000000e+00 -9.56552173e+38 0.00000000e+00 2.07252971e+39 0.00000000e+00 -2.99971405e+39 0.00000000e+00 2.69974265e+39 0.00000000e+00 -1.34987132e+39 0.00000000e+00 3.06788937e+38 0.00000000e+00 -2.00079742e+37 0.00000000e+00
 0.00000000e+00 0.00000000e+00 2.81474977e+14 0.00000000e+00 -1.58751887e+17 0.00000000e+00 4.10770507e+19 0.00000000e+00 -6.47648166e+21 0.00000000e+00 6.97031339e+23 0.00000000e+00 -5.43684445e+25 0.00000000e+00 3.18508470e+27 0.00000000e+00 -1.43328812e+29 0.00000000e+00 5.02546646e+30 0.00000000e+00 -1.38479520e+32 0.00000000e+00 3.01192956e+33 0.00000000e+00 -5.17504262e+34 0.00000000e+00 7.00787021e+35 0.00000000e+00 -7.43912376e+36 0.00000000e+00 6.13727710e+37 0.00000000e+00 -3.88694216e+38 0.00000000e+00 1.85844422e+39 0.00000000e+00 -6.55921490e+39 0.00000000e+00 1.65802377e+40 0.00000000e+00 -2.87972549e+40 0.00000000e+00 3.23969118e+40 0.00000000e+00 -2.15979412e+40 0.00000000e+00 7.36293449e+39 0.00000000e+00 -9.60382760e+38 0.00000000e+00 2.00079742e+37
 0.00000000e+00 5.62949953e+14 0.00000000e+00 -3.31014573e+17 0.00000000e+00 8.94566882e+19 0.00000000e+00 -1.47603536e+22 0.00000000e+00 1.66607491e+24 0.00000000e+00 -1.36618142e+26 0.00000000e+00 8.43617030e+27 0.00000000e+00 -4.01320673e+29 0.00000000e+00 1.49241125e+31 0.00000000e+00 -4.37773967e+32 0.00000000e+00 1.01782447e+34 0.00000000e+00 -1.87834880e+35 0.00000000e+00 2.74708512e+36 0.00000000e+00 -3.16971360e+37 0.00000000e+00 2.86406265e+38 0.00000000e+00 -2.00484385e+39 0.00000000e+00 1.07133843e+40 0.00000000e+00 -4.28535374e+40 0.00000000e+00 1.24989484e+41 0.00000000e+00 -2.56557362e+41 0.00000000e+00 3.52766373e+41 0.00000000e+00 -3.02371176e+41 0.00000000e+00 1.44313516e+41 0.00000000e+00 -3.13725035e+40 0.00000000e+00 1.96078147e+39 0.00000000e+00
 1.12589991e+15 0.00000000e+00 -6.89613693e+17 0.00000000e+00 1.94471061e+20 0.00000000e+00 -3.35462581e+22 0.00000000e+00 3.96684502e+24 0.00000000e+00 -3.41545356e+26 0.00000000e+00 2.22004482e+28 0.00000000e+00 -1.11477965e+30 0.00000000e+00 4.38944486e+31 0.00000000e+00 -1.36804365e+33 0.00000000e+00 3.39274825e+34 0.00000000e+00 -6.70838858e+35 0.00000000e+00 1.05657120e+37 0.00000000e+00 -1.32071400e+38 0.00000000e+00 1.30184666e+39 0.00000000e+00 -1.00242193e+40 0.00000000e+00 5.95188019e+40 0.00000000e+00 -2.67834609e+41 0.00000000e+00 8.92782029e+41 0.00000000e+00 -2.13797802e+42 0.00000000e+00 3.52766373e+42 0.00000000e+00 -3.77963971e+42 0.00000000e+00 2.40522527e+42 0.00000000e+00 -7.84312587e+41 0.00000000e+00 9.80390734e+40 0.00000000e+00 -1.96078147e+39];


  h_prev=[0 1];
  h_now=[2 0];

  if order == 0
    h=h_prev;
  else
    h=h_now;
  end

  if ( order >= 1 && order <= 50)
    h = H(order,51-order:end);
  end

  h_prev = H(49,2:end);
  h_now = H(50,1:end);

  if ( order > 50 )
    for ord=51:order
      x=[];y=[];
      if (length(h_now) < (1+ord))
        x=0;
      end;
      y=zeros(1,(1+ord)-length(h_prev));
      h=[2*h_now, x] -[y, 2*(ord-1)*h_prev];
      h_prev=h_now;
      h_now=h;
    end
  end

  if nargin == 2
    h = polyval(h,val);
  end
endfunction
