#include "AsxReader.h"
#include "avm_output.h"

#include <ctype.h>
#include <string.h>
#include <stdio.h>

AVM_BEGIN_NAMESPACE;

enum asx_position
{
    BEGIN,
    OPEN_BRACKET,
    CLOSE_BRACKET,
    IN_COMMENT,
    IN_QUOTED_COMMENT,
    IN_TAGNAME,
    AFTER_TAGNAME,
    IN_ENDTAG,
    BEFORE_TAGCLOSE,
    IN_PROPNAME,
    AFTER_PROPNAME,
    PROP_EQUAL,
    AFTER_PROPEQUAL,
    BETWEEN_PROPS,
    IN_PROPCONTENTS,
    IN_QUOTED_PROPCONTENTS,
    IN_QUOTED_CONTENTS,
    IN_CONTENTS,
};

bool ASXReader::addURL(const char* url)
{
    int i = 0;

    while (*url && (!isprint(*url) || (*url == '"')))
	url++;

    while (isprint(url[i]) && (url[i] != '"'))
	i++;

    if (i > 0)
    {
	avm::string vurl = avm::string(url, i);

	if (strncasecmp(vurl.c_str(), "mms://", 6) != 0
	    && strncasecmp(vurl.c_str(), "http://", 7) != 0)
	{
	    char* h = new char[m_Server.size() * 2 + m_Filename.size()];
	    if (h)
	    {
		int p = sprintf(h, "http://%s", m_Server.c_str());
		if (vurl[0] != '/')
		{
		    h[p++] = '/';
		    strcpy(h + p, m_Filename.c_str());
		    char* q = strchr(h + p, '?'); // strip all after '?'
		    if (q) *q = 0;
		}
		//printf("_____addUrl>%s<>%s<____\n", h, vurl.c_str());
		vurl.insert(0, h);
	    }
	}

	//printf("URL:%s<\n", vurl.c_str());
	m_Urls.push_back(vurl);
        return true;
    }
    return false;
}

bool ASXReader::create(const char* data, size_t size)
{
    int last_start = 0;
    avm::string last_tag;
    avm::string last_prop;
    avm::string last_prop_val;
    m_Urls.clear();

    //printf("PARSE >%s< %d\n", data, size);
    asx_position state = BEGIN;
    for (unsigned i = 0; i < size; i++)
    {
	unsigned char c = data[i];
	if (c < 6) break; // stop processing
	//printf("i %d %c   %d\n", i, c, state);
	int is_alpha = isalpha(c) || (c >= 0x80);
	int is_space = isspace(c);
	switch(state)
	{
	case BEGIN:
	    if (c == '<')
		state = OPEN_BRACKET;
	    else if (is_alpha)
	    {
                // sometime only single one line redirection appears
		if (!strncasecmp(data + i, "mms://", 6)
                    || !strncasecmp(data + i, "http://", 7))
                    return addURL(data + i);
	    }
            continue;
	case OPEN_BRACKET:
	    if (c == '!')
		state = IN_COMMENT;
	    else if (c == '/')
	    {
		state = IN_ENDTAG;
		last_start = i + 1;
	    }
	    else if (is_alpha)
	    {
		state = IN_TAGNAME;
		last_start = i;
	    }
            else if (!is_space)
		return false;
	    continue;
	case IN_COMMENT:
	    if (c == '"')
		state = IN_QUOTED_COMMENT;
	    else if (c == '>')
		state = CLOSE_BRACKET;
	    continue;
	case IN_QUOTED_COMMENT:
	    if (c == '"')
		state = IN_COMMENT;
	    continue;
	case CLOSE_BRACKET:
	    if (c == '<')
		state = OPEN_BRACKET;
            else
		state = IN_CONTENTS;
	    continue;
	case IN_TAGNAME:
	    if (is_space)
	    {
		last_tag = avm::string(&data[last_start], i-last_start);
		//printf("TAG1: %s\n", last_tag.c_str());
		state = AFTER_TAGNAME;
	    }
	    else if ((c == '/') || (c == '>'))
	    {
		last_tag = avm::string(&data[last_start], i-last_start);
		//printf("TAG2: %s\n", last_tag.c_str());
		if (c == '/')
	    	    state = BEFORE_TAGCLOSE;
		else
		    state = CLOSE_BRACKET;
	    }
	    continue;
	case AFTER_TAGNAME:
	    if (c == '/')
		state = BEFORE_TAGCLOSE;
	    else if (!is_space)
	    {
		last_start = i;
		state = IN_PROPNAME;
	    }
	    continue;
	case IN_ENDTAG:
	    if (c == '>')
	    {
		last_tag = avm::string(&data[last_start], i-last_start);
		state = CLOSE_BRACKET;
		AVM_WRITE("ASX reader", 1, " TAG: %s\n", last_tag.c_str());
		if (last_tag == "asx")
		    return true;
	    }
	    continue;
	case BEFORE_TAGCLOSE:
	    if (c == '>')
		state = CLOSE_BRACKET;
	    else if (!is_space)
		return false;
	    continue;
	case IN_PROPNAME:
	    if (c == '=')
	    {
		last_prop = avm::string(&data[last_start], i-last_start);
		state = PROP_EQUAL;
	    }
	    else if (is_space)
	    {
		last_prop = avm::string(&data[last_start], i-last_start);
		state = AFTER_PROPNAME;
	    }
	    continue;
	case AFTER_PROPNAME:
	    if (c == '=')
		state = PROP_EQUAL;
	    continue;
	case PROP_EQUAL:
	    if (is_space)
		continue;
	    if (c == '"')
		state = IN_QUOTED_PROPCONTENTS;
	    else
	        state = IN_PROPCONTENTS;
	    last_start = i;
	    continue;
	case IN_PROPCONTENTS:
	    if (c == '"')
		state = IN_QUOTED_PROPCONTENTS;
	    else if (is_space || (c == '/') || (c == '>'))
	    {
		last_prop_val = avm::string(&data[last_start], i-last_start);

		AVM_WRITE("ASX reader", 1, "VALUE: %s  t:%s p:%s\n", last_prop_val.c_str(), last_tag.c_str(), last_prop.c_str());
		if (last_tag.tolower() == "ref"
		    || last_tag == "entryref"
		    || last_tag == "a"
		    || last_tag == "location"
                    || last_tag == "embed") // part of some javascript
		    if (last_prop.tolower() == "href"
			|| last_prop == "src")
			addURL(last_prop_val.c_str());
		if (c == '/')
		    state = BEFORE_TAGCLOSE;
		else if (c == '>')
		    state = CLOSE_BRACKET;
		else
		    state = BETWEEN_PROPS;
	    }
	    continue;
	case IN_QUOTED_PROPCONTENTS:
	    if (c == '"')
		state = IN_PROPCONTENTS;
	    continue;
	case BETWEEN_PROPS:
	    if (c == '/')
		state = BEFORE_TAGCLOSE;
	    else if (c == '>')
	        state = CLOSE_BRACKET;
	    else if (is_alpha)
	    {
		last_start = i;
		state = IN_PROPNAME;
	    }
	    else if (!is_space)
		return false;
	    continue;
	case IN_CONTENTS:
	    if (c == '"')
		state = IN_QUOTED_CONTENTS;
	    else if (c == '<')
		state = OPEN_BRACKET;
	    continue;
	case IN_QUOTED_CONTENTS:
	    if (c == '"')
		state = IN_CONTENTS;
	    continue;
	default: // after_propequal
	    AVM_WRITE("ASX reader", "FIXME ERROR after_propequal not handled\n");
            break;
	}
    }
    return (m_Urls.size() > 0);
}

bool ASXReader::getURLs(avm::vector<avm::string>& urls) const
{
    //for (unsigned i = 0; i < m_Urls.size(); i++) printf("URLs: %s\n", m_Urls[i].c_str());
    urls = m_Urls;
    return true;
}

AVM_END_NAMESPACE;
