{-# LANGUAGE CPP,MagicHash #-}
{-# LINE 1 "HOpenPGP/Tools/Lexer.x" #-}

{-# OPTIONS -w #-}
module HOpenPGP.Tools.Lexer
( alexEOF
, alexSetInput
, alexGetInput
, alexError
, alexScan
, ignorePendingBytes
, alexGetStartCode
, runAlex
, Alex(..)
, Token(..)
, AlexReturn(..)
, AlexPosn(..)
) where

import Prelude hiding (lex)
import Numeric (readHex)
import Codec.Encryption.OpenPGP.Types (TwentyOctetFingerprint(..), EightOctetKeyId(..))


#if __GLASGOW_HASKELL__ >= 603
#include "ghcconfig.h"
#elif defined(__GLASGOW_HASKELL__)
#include "config.h"
#endif
#if __GLASGOW_HASKELL__ >= 503
import Data.Array
import Data.Char (ord)
import Data.Array.Base (unsafeAt)
#else
import Array
import Char (ord)
#endif
#if __GLASGOW_HASKELL__ >= 503
import GHC.Exts
#else
import GlaExts
#endif
{-# LINE 1 "templates/wrappers.hs" #-}
{-# LINE 1 "templates/wrappers.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 1 "<command-line>" #-}
{-# LINE 8 "<command-line>" #-}
# 1 "/usr/include/stdc-predef.h" 1 3 4

# 17 "/usr/include/stdc-predef.h" 3 4










































{-# LINE 8 "<command-line>" #-}
{-# LINE 1 "templates/wrappers.hs" #-}
-- -----------------------------------------------------------------------------
-- Alex wrapper code.
--
-- This code is in the PUBLIC DOMAIN; you may copy it freely and use
-- it for any purpose whatsoever.

import Control.Applicative (Applicative (..))
import Data.Word (Word8)
{-# LINE 23 "templates/wrappers.hs" #-}

import qualified Data.Bits

-- | Encode a Haskell String to a list of Word8 values, in UTF8 format.
utf8Encode :: Char -> [Word8]
utf8Encode = map fromIntegral . go . ord
 where
  go oc
   | oc <= 0x7f       = [oc]

   | oc <= 0x7ff      = [ 0xc0 + (oc `Data.Bits.shiftR` 6)
                        , 0x80 + oc Data.Bits..&. 0x3f
                        ]

   | oc <= 0xffff     = [ 0xe0 + (oc `Data.Bits.shiftR` 12)
                        , 0x80 + ((oc `Data.Bits.shiftR` 6) Data.Bits..&. 0x3f)
                        , 0x80 + oc Data.Bits..&. 0x3f
                        ]
   | otherwise        = [ 0xf0 + (oc `Data.Bits.shiftR` 18)
                        , 0x80 + ((oc `Data.Bits.shiftR` 12) Data.Bits..&. 0x3f)
                        , 0x80 + ((oc `Data.Bits.shiftR` 6) Data.Bits..&. 0x3f)
                        , 0x80 + oc Data.Bits..&. 0x3f
                        ]



type Byte = Word8

-- -----------------------------------------------------------------------------
-- The input type


type AlexInput = (AlexPosn,     -- current position,
                  Char,         -- previous char
                  [Byte],       -- pending bytes on current char
                  String)       -- current input string

ignorePendingBytes :: AlexInput -> AlexInput
ignorePendingBytes (p,c,ps,s) = (p,c,[],s)

alexInputPrevChar :: AlexInput -> Char
alexInputPrevChar (p,c,bs,s) = c

alexGetByte :: AlexInput -> Maybe (Byte,AlexInput)
alexGetByte (p,c,(b:bs),s) = Just (b,(p,c,bs,s))
alexGetByte (p,c,[],[]) = Nothing
alexGetByte (p,_,[],(c:s))  = let p' = alexMove p c 
                                  (b:bs) = utf8Encode c
                              in p' `seq`  Just (b, (p', c, bs, s))


{-# LINE 93 "templates/wrappers.hs" #-}

{-# LINE 107 "templates/wrappers.hs" #-}

{-# LINE 122 "templates/wrappers.hs" #-}

-- -----------------------------------------------------------------------------
-- Token positions

-- `Posn' records the location of a token in the input text.  It has three
-- fields: the address (number of chacaters preceding the token), line number
-- and column of a token within the file. `start_pos' gives the position of the
-- start of the file and `eof_pos' a standard encoding for the end of file.
-- `move_pos' calculates the new position after traversing a given character,
-- assuming the usual eight character tab stops.


data AlexPosn = AlexPn !Int !Int !Int
        deriving (Eq,Show)

alexStartPos :: AlexPosn
alexStartPos = AlexPn 0 1 1

alexMove :: AlexPosn -> Char -> AlexPosn
alexMove (AlexPn a l c) '\t' = AlexPn (a+1)  l     (((c+7) `div` 8)*8+1)
alexMove (AlexPn a l c) '\n' = AlexPn (a+1) (l+1)   1
alexMove (AlexPn a l c) _    = AlexPn (a+1)  l     (c+1)


-- -----------------------------------------------------------------------------
-- Default monad


data AlexState = AlexState {
        alex_pos :: !AlexPosn,  -- position at current input location
        alex_inp :: String,     -- the current input
        alex_chr :: !Char,      -- the character before the input
        alex_bytes :: [Byte],
        alex_scd :: !Int        -- the current startcode



    }

-- Compile with -funbox-strict-fields for best results!

runAlex :: String -> Alex a -> Either String a
runAlex input (Alex f) 
   = case f (AlexState {alex_pos = alexStartPos,
                        alex_inp = input,       
                        alex_chr = '\n',
                        alex_bytes = [],



                        alex_scd = 0}) of Left msg -> Left msg
                                          Right ( _, a ) -> Right a

newtype Alex a = Alex { unAlex :: AlexState -> Either String (AlexState, a) }

instance Functor Alex where
  fmap f a = Alex $ \s -> case unAlex a s of
                            Left msg -> Left msg
                            Right (s', a') -> Right (s', f a')

instance Applicative Alex where
  pure a   = Alex $ \s -> Right (s, a)
  fa <*> a = Alex $ \s -> case unAlex fa s of
                            Left msg -> Left msg
                            Right (s', f) -> case unAlex a s' of
                                               Left msg -> Left msg
                                               Right (s'', b) -> Right (s'', f b)

instance Monad Alex where
  m >>= k  = Alex $ \s -> case unAlex m s of 
                                Left msg -> Left msg
                                Right (s',a) -> unAlex (k a) s'
  return a = Alex $ \s -> Right (s,a)

alexGetInput :: Alex AlexInput
alexGetInput
 = Alex $ \s@AlexState{alex_pos=pos,alex_chr=c,alex_bytes=bs,alex_inp=inp} -> 
        Right (s, (pos,c,bs,inp))

alexSetInput :: AlexInput -> Alex ()
alexSetInput (pos,c,bs,inp)
 = Alex $ \s -> case s{alex_pos=pos,alex_chr=c,alex_bytes=bs,alex_inp=inp} of
                  s@(AlexState{}) -> Right (s, ())

alexError :: String -> Alex a
alexError message = Alex $ \s -> Left message

alexGetStartCode :: Alex Int
alexGetStartCode = Alex $ \s@AlexState{alex_scd=sc} -> Right (s, sc)

alexSetStartCode :: Int -> Alex ()
alexSetStartCode sc = Alex $ \s -> Right (s{alex_scd=sc}, ())









alexMonadScan = do
  inp <- alexGetInput
  sc <- alexGetStartCode
  case alexScan inp sc of
    AlexEOF -> alexEOF
    AlexError ((AlexPn _ line column),_,_,_) -> alexError $ "lexical error at line " ++ (show line) ++ ", column " ++ (show column)
    AlexSkip  inp' len -> do
        alexSetInput inp'
        alexMonadScan
    AlexToken inp' len action -> do
        alexSetInput inp'
        action (ignorePendingBytes inp) len

-- -----------------------------------------------------------------------------
-- Useful token actions

type AlexAction result = AlexInput -> Int -> Alex result

-- just ignore this token and scan another one
-- skip :: AlexAction result
skip input len = alexMonadScan

-- ignore this token, but set the start code to a new value
-- begin :: Int -> AlexAction result
begin code input len = do alexSetStartCode code; alexMonadScan

-- perform an action for this token, and set the start code to a new value
andBegin :: AlexAction result -> Int -> AlexAction result
(action `andBegin` code) input len = do alexSetStartCode code; action input len

token :: (AlexInput -> Int -> token) -> AlexAction token
token t input len = return (t input len)



-- -----------------------------------------------------------------------------
-- Monad (with ByteString input)

{-# LINE 347 "templates/wrappers.hs" #-}


-- -----------------------------------------------------------------------------
-- Basic wrapper

{-# LINE 374 "templates/wrappers.hs" #-}


-- -----------------------------------------------------------------------------
-- Basic wrapper, ByteString version

{-# LINE 392 "templates/wrappers.hs" #-}

{-# LINE 406 "templates/wrappers.hs" #-}


-- -----------------------------------------------------------------------------
-- Posn wrapper

-- Adds text positions to the basic model.

{-# LINE 423 "templates/wrappers.hs" #-}


-- -----------------------------------------------------------------------------
-- Posn wrapper, ByteString version

{-# LINE 438 "templates/wrappers.hs" #-}


-- -----------------------------------------------------------------------------
-- GScan wrapper

-- For compatibility with previous versions of Alex, and because we can.

alex_base :: AlexAddr
alex_base = AlexA# "\xf8\xff\xff\xff\x8d\xff\xff\xff\xa2\xff\xff\xff\x8f\xff\xff\xff\xa3\xff\xff\xff\x96\xff\xff\xff\x98\xff\xff\xff\xa7\xff\xff\xff\x9e\xff\xff\xff\x9f\xff\xff\xff\xa0\xff\xff\xff\xd1\xff\xff\xff\xd2\xff\xff\xff\xd6\xff\xff\xff\x97\xff\xff\xff\xac\xff\xff\xff\xad\xff\xff\xff\xae\xff\xff\xff\x9d\xff\xff\xff\xb2\xff\xff\xff\xb4\xff\xff\xff\xb5\xff\xff\xff\xb6\xff\xff\xff\xe9\xff\xff\xff\xf1\xff\xff\xff\xc5\xff\xff\xff\xba\xff\xff\xff\xb8\xff\xff\xff\xc0\xff\xff\xff\xe0\xff\xff\xff\xd3\xff\xff\xff\xd5\xff\xff\xff\xdf\xff\xff\xff\xe7\xff\xff\xff\xe8\xff\xff\xff\x0e\x00\x00\x00\xe6\xff\xff\xff\xea\xff\xff\xff\xeb\xff\xff\xff\xec\xff\xff\xff\xed\xff\xff\xff\xef\xff\xff\xff\xf9\xff\xff\xff\x05\x00\x00\x00\x0f\x00\x00\x00\x20\x00\x00\x00\x38\x00\x00\x00\x02\x00\x00\x00\x1f\x00\x00\x00\x0d\x00\x00\x00\x08\x00\x00\x00\x13\x00\x00\x00\x0c\x00\x00\x00\x10\x00\x00\x00\x11\x00\x00\x00\xfd\xff\xff\xff\x0b\x00\x00\x00\x1a\x00\x00\x00\x17\x00\x00\x00\x14\x00\x00\x00\x18\x00\x00\x00\x19\x00\x00\x00\x1b\x00\x00\x00\x1d\x00\x00\x00\x2c\x00\x00\x00\x31\x00\x00\x00\x3a\x00\x00\x00\x33\x00\x00\x00\x34\x00\x00\x00\x36\x00\x00\x00\x37\x00\x00\x00\x5a\x00\x00\x00\x43\x00\x00\x00\x24\x00\x00\x00\x27\x00\x00\x00\x2e\x00\x00\x00\x2a\x00\x00\x00\x1c\x00\x00\x00\x2d\x00\x00\x00\x21\x00\x00\x00\x2f\x00\x00\x00\x25\x00\x00\x00\x26\x00\x00\x00\xec\x00\x00\x00\xed\x00\x00\x00\xee\x00\x00\x00\xef\x00\x00\x00\x39\x00\x00\x00\xf0\x00\x00\x00\xf1\x00\x00\x00\xf2\x00\x00\x00\xf3\x00\x00\x00\x30\x00\x00\x00\x35\x00\x00\x00\xf6\x00\x00\x00\x3b\x00\x00\x00\xe4\x00\x00\x00\x3c\x00\x00\x00\x41\x00\x00\x00\x99\x01\x00\x00\x9a\x01\x00\x00\xe6\x00\x00\x00\xeb\x00\x00\x00\x3d\x00\x00\x00\x3e\x00\x00\x00\x4a\x00\x00\x00\xd3\x00\x00\x00\xca\x00\x00\x00\xcb\x00\x00\x00\xcc\x00\x00\x00\xcf\x00\x00\x00\xf4\x00\x00\x00\xd8\x00\x00\x00\x28\x00\x00\x00\xd9\x00\x00\x00\xda\x00\x00\x00\xcd\x00\x00\x00\xe1\x00\x00\x00\x2b\x00\x00\x00\xe2\x00\x00\x00\xdb\x00\x00\x00\xdc\x00\x00\x00\x97\x01\x00\x00\xdd\x00\x00\x00\xde\x00\x00\x00\xdf\x00\x00\x00\xe8\x00\x00\x00\xa2\x01\x00\x00\xe5\x00\x00\x00\xea\x00\x00\x00\x3f\x00\x00\x00\xe9\x00\x00\x00\xd7\x00\x00\x00\xf5\x00\x00\x00\xe0\x00\x00\x00\x7b\x01\x00\x00\xf7\x00\x00\x00\xf9\x00\x00\x00\xfa\x00\x00\x00\xf8\x00\x00\x00\xe7\x00\x00\x00\xfe\x00\x00\x00\xff\x00\x00\x00\x88\x01\x00\x00\x77\x01\x00\x00\x84\x01\x00\x00\x83\x01\x00\x00\x85\x01\x00\x00\x86\x01\x00\x00\x8a\x01\x00\x00\x8d\x01\x00\x00\x8e\x01\x00\x00\x8f\x01\x00\x00\x87\x01\x00\x00\x90\x01\x00\x00\x7f\x01\x00\x00\x94\x01\x00\x00\x89\x01\x00\x00\x8b\x01\x00\x00\x8c\x01\x00\x00\x93\x01\x00\x00\x7a\x01\x00\x00\x80\x01\x00\x00\x98\x01\x00\x00\xa1\x01\x00\x00\x9c\x01\x00\x00\x9d\x01\x00\x00\x9e\x01\x00\x00\xa8\x01\x00\x00\xa9\x01\x00\x00\x32\x00\x00\x00\xb1\x01\x00\x00\xa6\x01\x00\x00\x9b\x01\x00\x00\x9f\x01\x00\x00\xab\x01\x00\x00\xac\x01\x00\x00\xb2\x01\x00\x00\xa5\x01\x00\x00\xa0\x01\x00\x00\xad\x01\x00\x00\xb6\x01\x00\x00\xa7\x01\x00\x00\xae\x01\x00\x00\xaf\x01\x00\x00\xaa\x01\x00\x00\xd5\x01\x00\x00\xb8\x01\x00\x00\xcb\x01\x00\x00\xcd\x01\x00\x00\xb0\x01\x00\x00\xb3\x01\x00\x00\xb4\x01\x00\x00\xb5\x01\x00\x00\xe1\x01\x00\x00\xe2\x01\x00\x00\xb7\x01\x00\x00\xb9\x01\x00\x00\xba\x01\x00\x00\xc0\x01\x00\x00\xc1\x01\x00\x00\xbb\x01\x00\x00\xc2\x01\x00\x00\xc3\x01\x00\x00\xbe\x01\x00\x00\xd6\x01\x00\x00\xbf\x01\x00\x00\xc4\x01\x00\x00\xc6\x01\x00\x00\xc7\x01\x00\x00\xd1\x01\x00\x00\xd2\x01\x00\x00\xc5\x01\x00\x00\xce\x01\x00\x00\xcc\x01\x00\x00\xca\x01\x00\x00\xd3\x01\x00\x00\xde\x01\x00\x00\xd7\x01\x00\x00\xd8\x01\x00\x00\xd9\x01\x00\x00\xdb\x01\x00\x00\xdc\x01\x00\x00\xbc\x01\x00\x00\xdf\x01\x00\x00\xe4\x01\x00\x00\xdd\x01\x00\x00\xe0\x01\x00\x00\xda\x01\x00\x00\x00\x00\x00\x00\xc8\x01\x00\x00\xe3\x01\x00\x00\x54\x02\x00\x00\xe5\x01\x00\x00\x85\x02\x00\x00\xe6\x01\x00\x00\x5c\x02\x00\x00\x5d\x02\x00\x00\x5e\x02\x00\x00\x61\x02\x00\x00\x7a\x02\x00\x00\x62\x02\x00\x00\x7f\x02\x00\x00\x82\x02\x00\x00\xeb\x01\x00\x00\x00\x00\x00\x00\x3a\x02\x00\x00\xf2\x02\x00\x00\xf4\x02\x00\x00\x65\x02\x00\x00\x68\x02\x00\x00\x69\x02\x00\x00\x6a\x03\x00\x00\x2a\x03\x00\x00\x00\x00\x00\x00\x6a\x02\x00\x00\x63\x02\x00\x00\x5f\x02\x00\x00\xfa\x02\x00\x00\x18\x02\x00\x00\x1b\x02\x00\x00\xfb\x02\x00\x00\x6b\x02\x00\x00\x6c\x02\x00\x00\x6d\x02\x00\x00\x6e\x02\x00\x00\x73\x02\x00\x00\x64\x02\x00\x00\x70\x02\x00\x00\x74\x02\x00\x00\x75\x02\x00\x00\x6f\x02\x00\x00\x76\x02\x00\x00\x20\x04\x00\x00\xfb\x03\x00\x00\x81\x02\x00\x00\x66\x02\x00\x00\x77\x02\x00\x00\x7e\x02\x00\x00\xb6\x02\x00\x00\xb9\x02\x00\x00\xb8\x02\x00\x00\xbb\x02\x00\x00\xc4\x02\x00\x00\x83\x02\x00\x00\xc7\x02\x00\x00\xc9\x02\x00\x00\xcc\x02\x00\x00\xcd\x02\x00\x00\x89\x02\x00\x00\xd4\x02\x00\x00\xd5\x02\x00\x00\xde\x02\x00\x00\xd1\x02\x00\x00\xe7\x02\x00\x00\x2c\x04\x00\x00\x21\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf9\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf5\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x04\x00\x00\x07\x05\x00\x00\x2d\x05\x00\x00\x44\x05\x00\x00\x6a\x05\x00\x00\x81\x05\x00\x00\xa7\x05\x00\x00\xbe\x05\x00\x00\xe4\x05\x00\x00\xfb\x05\x00\x00\x21\x06\x00\x00\x38\x06\x00\x00\x5e\x06\x00\x00\x75\x06\x00\x00\x9b\x06\x00\x00\xb2\x06\x00\x00\xd8\x06\x00\x00\xf0\x06\x00\x00\x16\x07\x00\x00\x2d\x07\x00\x00\x53\x07\x00\x00\x6a\x07\x00\x00\x90\x07\x00\x00\xa7\x07\x00\x00\xcd\x07\x00\x00\xe4\x07\x00\x00\x0a\x08\x00\x00\x21\x08\x00\x00\x47\x08\x00\x00\x5e\x08\x00\x00\x84\x08\x00\x00\x9b\x08\x00\x00\xc1\x08\x00\x00\xd8\x08\x00\x00\xfe\x08\x00\x00\x15\x09\x00\x00\x3b\x09\x00\x00\x52\x09\x00\x00\x78\x09\x00\x00\x8f\x09\x00\x00\xb5\x09\x00\x00\xcc\x09\x00\x00\xf2\x09\x00\x00\x09\x0a\x00\x00\x2f\x0a\x00\x00\x46\x0a\x00\x00\x6c\x0a\x00\x00\x83\x0a\x00\x00\xca\x0a\x00\x00\xe1\x0a\x00\x00\x07\x0b\x00\x00\x1e\x0b\x00\x00\x44\x0b\x00\x00\x5b\x0b\x00\x00\x81\x0b\x00\x00\x98\x0b\x00\x00\xbe\x0b\x00\x00\xd5\x0b\x00\x00\x0f\x0c\x00\x00\x26\x0c\x00\x00\x5d\x0c\x00\x00\x74\x0c\x00\x00\x9a\x0c\x00\x00\xb1\x0c\x00\x00\xd7\x0c\x00\x00\xfd\x0c\x00\x00\x14\x0d\x00\x00\x4b\x0d\x00\x00\x62\x0d\x00\x00\x88\x0d\x00\x00\x9f\x0d\x00\x00\xc5\x0d\x00\x00\xdc\x0d\x00\x00\x02\x0e\x00\x00\x19\x0e\x00\x00\x3f\x0e\x00\x00\x56\x0e\x00\x00\x7c\x0e\x00\x00\x93\x0e\x00\x00\xb9\x0e\x00\x00\xd0\x0e\x00\x00\xf6\x0e\x00\x00\x0d\x0f\x00\x00\x33\x0f\x00\x00\x4a\x0f\x00\x00\x70\x0f\x00\x00\x87\x0f\x00\x00\xad\x0f\x00\x00\xc4\x0f\x00\x00\xea\x0f\x00\x00\x01\x10\x00\x00\x27\x10\x00\x00\x3e\x10\x00\x00\x64\x10\x00\x00\x7b\x10\x00\x00\xb4\x10\x00\x00\xcd\x10\x00\x00\x04\x11\x00\x00\x1b\x11\x00\x00\x41\x11\x00\x00\x58\x11\x00\x00\x7e\x11\x00\x00\x95\x11\x00\x00\xbb\x11\x00\x00\xd2\x11\x00\x00\xf8\x11\x00\x00\x0f\x12\x00\x00\x35\x12\x00\x00\x4c\x12\x00\x00\x72\x12\x00\x00\x89\x12\x00\x00\xaf\x12\x00\x00\xc6\x12\x00\x00\xec\x12\x00\x00\x03\x13\x00\x00\x29\x13\x00\x00\x40\x13\x00\x00\x66\x13\x00\x00\x7d\x13\x00\x00\xa3\x13\x00\x00\xba\x13\x00\x00\xe0\x13\x00\x00\xf7\x13\x00\x00\x1d\x14\x00\x00\x34\x14\x00\x00\x5a\x14\x00\x00\x71\x14\x00\x00\x97\x14\x00\x00\xae\x14\x00\x00\xd4\x14\x00\x00\xeb\x14\x00\x00\x11\x15\x00\x00\x28\x15\x00\x00\x4e\x15\x00\x00\x65\x15\x00\x00\x58\x15\x00\x00"#

alex_table :: AlexAddr
alex_table = AlexA# "\x00\x00\x27\x01\x27\x01\x27\x01\x27\x01\x27\x01\x2b\x01\x2d\x01\x2f\x01\x34\x01\x30\x01\x39\x01\x3c\x01\x3d\x01\x3e\x01\x3f\x01\x46\x01\x48\x01\x40\x01\x41\x01\x4d\x01\x4e\x01\x4f\x01\x43\x01\x27\x01\x50\x01\x11\x01\x51\x01\x52\x01\x53\x01\x54\x01\x5c\x01\x37\x01\x38\x01\x55\x01\x2d\x00\x03\x01\x03\x00\x2e\x00\x25\x01\x71\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x40\x01\x41\x01\x35\x01\x33\x01\x36\x01\x43\x01\x5b\x01\x9e\x01\x9a\x01\x9c\x01\xbf\x01\x8f\x01\x9e\x01\x9a\x00\x81\x00\x04\x00\x23\x01\xb0\x00\x22\x01\x05\x01\x08\x00\x21\x01\x63\x00\x87\x00\x23\x00\xf8\x00\xa4\x00\x48\x00\x09\x00\x0a\x00\x18\x00\x12\x00\x17\x01\x10\x00\x11\x00\x1a\x01\x13\x00\xcd\x00\x14\x00\x28\x01\x9a\x01\x9b\x01\xbf\x01\x90\x01\x9d\x01\x9a\x00\x81\x00\x0b\x00\x15\x00\x5f\x00\x70\x00\x05\x01\x1b\x00\x24\x01\x64\x00\x18\x01\x23\x00\xf7\x00\x1d\x00\x48\x00\x16\x00\x15\x01\x18\x00\xa7\x00\x10\x01\x1c\x00\x0f\x01\x0e\x01\x0d\x01\xcd\x00\x24\x00\x1e\x00\x1f\x00\x0c\x01\x0b\x01\x09\x01\x08\x01\x25\x00\x07\x01\x0b\x00\x06\x01\x0a\x01\x26\x00\x27\x00\x28\x00\x29\x00\x13\x01\x2a\x00\x2b\x00\x04\x01\x02\x01\x01\x01\x00\x01\x2f\x00\x34\x00\xa7\x00\x49\x00\xff\x00\x68\x00\x30\x00\x33\x00\x40\x00\x35\x00\x36\x00\x38\x00\xe8\x00\x41\x00\xa5\x00\xef\x00\x25\x00\x4d\x00\x58\x00\x75\x00\xf2\x00\x26\x00\x27\x00\x28\x00\x29\x00\xf3\x00\x2a\x00\x2b\x00\x59\x00\x02\x01\xfc\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfb\x00\xfb\x00\xfa\x00\xf9\x00\x55\x00\x57\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x42\x00\x5b\x00\xee\x00\xed\x00\xec\x00\xeb\x00\xe9\x00\xe3\x00\xe2\x00\xe1\x00\xea\x00\xe0\x00\xdf\x00\xde\x00\xdd\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x71\x00\x74\x00\x77\x00\xfb\x00\xfb\x00\xfa\x00\xf9\x00\x55\x00\x57\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x42\x00\xd8\x00\x7a\x00\x83\x00\xd5\x00\xd6\x00\xd4\x00\xd7\x00\xd1\x00\xd0\x00\xea\x00\x82\x00\x72\x00\x4e\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\x53\x00\x53\x00\xdc\x00\x6f\x00\x80\x00\xcf\x00\xce\x00\x88\x00\xcc\x00\x8d\x00\xcb\x00\xca\x00\x8e\x00\x8f\x00\x92\x00\xc3\x00\x90\x00\xc7\x00\xc8\x00\xc5\x00\x95\x00\xc2\x00\x96\x00\x97\x00\xa6\x00\x9c\x00\xc6\x00\xc6\x00\x98\x00\xa1\x00\xa2\x00\xc1\x00\x53\x00\x54\x00\xdc\x00\x6f\x00\x9b\x00\x9b\x00\xa0\x00\xb4\x00\xb4\x00\xc0\x00\xbf\x00\xbe\x00\xba\x00\xae\x00\xb1\x00\xb8\x00\xab\x00\xb7\x00\xb2\x00\xb6\x00\xbd\x00\xac\x00\xaa\x00\xb3\x00\xa6\x00\xa9\x00\xbc\x00\xa7\x00\xaf\x00\xad\x00\xa3\x00\x94\x00\x93\x00\x91\x00\x7f\x00\x86\x00\x5a\x00\x9f\x00\x9e\x00\x9d\x00\x8c\x00\xc9\x00\x8b\x00\x89\x00\xd2\x00\xd3\x00\x85\x00\x7e\x00\xa8\x00\x79\x00\x78\x00\x76\x00\x7d\x00\xac\x00\x7c\x00\x7b\x00\xd9\x00\xa9\x00\xdb\x00\xa7\x00\x6a\x00\x69\x00\x67\x00\x94\x00\x93\x00\xe4\x00\x7f\x00\x5e\x00\xe7\x00\x5d\x00\x5c\x00\xf0\x00\x56\x00\x32\x00\x50\x00\x52\x00\x19\x01\x1b\x01\x51\x00\x4a\x00\xa8\x00\x4c\x00\x46\x00\xf6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4b\x00\x47\x00\x45\x00\x44\x00\x43\x00\x3b\x00\x3a\x00\x65\x00\x39\x00\x22\x00\x65\x00\x37\x00\x21\x00\x20\x00\x37\x00\x16\x01\x14\x01\x1a\x00\x5f\x01\x05\x00\x20\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01\x0f\x00\x0e\x00\x06\x00\x07\x00\x60\x01\x5d\x01\x5e\x01\x01\x00\x47\x00\x5a\x01\x59\x01\x58\x01\xb5\x00\x3a\x00\x65\x00\xb5\x00\x57\x01\x65\x00\x37\x00\x56\x01\x42\x01\x37\x00\x4c\x01\x73\x00\xfd\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2c\x00\x4b\x01\x2c\x00\x4a\x01\x19\x00\x17\x00\x49\x01\x47\x01\x3b\x01\x3a\x01\x31\x01\x2c\x01\x32\x01\x00\x00\x00\x00\x00\x00\x00\x00\x29\x01\x02\x00\x00\x00\x00\x00\x00\x00\x2e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x62\x00\x2c\x00\x61\x00\x19\x00\x17\x00\x2a\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8a\x00\xf4\x00\x8a\x00\xbb\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\x27\x01\x27\x01\x27\x01\x27\x01\x27\x01\x00\x00\x93\x00\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xe8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\xa8\x00\x27\x01\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x93\x00\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x2b\x00\x00\x00\x00\x00\xa8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x26\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfc\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfd\x00\x4e\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf6\x00\x60\x00\xe5\x00\xe5\x00\xe5\x00\xe6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x67\x01\x67\x01\x67\x01\x67\x01\x67\x01\x67\x01\x67\x01\x67\x01\x67\x01\x67\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x00\x00\x00\x00\x00\x00\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\x00\x00\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x00\x00\x00\x00\x00\x00\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x68\x01\x00\x00\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\x00\x00\x00\x00\x00\x00\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\x01\x67\x01\x67\x01\x67\x01\x67\x01\x67\x01\x67\x01\x67\x01\x67\x01\x67\x01\x00\x00\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x69\x01\x69\x01\x69\x01\x69\x01\x69\x01\x69\x01\x69\x01\x69\x01\x69\x01\x69\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x00\x00\x00\x00\x00\x00\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\x01\x6a\x01\x6a\x01\x6a\x01\x6a\x01\x6a\x01\x6a\x01\x6a\x01\x6a\x01\x6a\x01\x00\x00\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x6b\x01\x6b\x01\x6b\x01\x6b\x01\x6b\x01\x6b\x01\x6b\x01\x6b\x01\x6b\x01\x6b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x00\x00\x00\x00\x00\x00\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6c\x01\x6c\x01\x6c\x01\x6c\x01\x6c\x01\x6c\x01\x6c\x01\x6c\x01\x6c\x01\x6c\x01\x00\x00\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x6d\x01\x6d\x01\x6d\x01\x6d\x01\x6d\x01\x6d\x01\x6d\x01\x6d\x01\x6d\x01\x6d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x00\x00\x00\x00\x00\x00\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x00\x00\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x00\x00\x00\x00\x00\x00\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x72\x01\x72\x01\x72\x01\x72\x01\x72\x01\x72\x01\x72\x01\x72\x01\x72\x01\x72\x01\x00\x00\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x01\x75\x01\x75\x01\x75\x01\x75\x01\x75\x01\x75\x01\x75\x01\x75\x01\x75\x01\x12\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x76\x01\x76\x01\x76\x01\x76\x01\x76\x01\x76\x01\x76\x01\x76\x01\x76\x01\x76\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\x00\x00\x00\x00\x00\x00\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x77\x01\x77\x01\x77\x01\x77\x01\x77\x01\x77\x01\x77\x01\x77\x01\x77\x01\x77\x01\x00\x00\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\x78\x01\x78\x01\x78\x01\x78\x01\x78\x01\x78\x01\x78\x01\x78\x01\x78\x01\x78\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\x00\x00\x00\x00\x00\x00\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x01\x79\x01\x79\x01\x79\x01\x79\x01\x79\x01\x79\x01\x79\x01\x79\x01\x79\x01\x00\x00\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\x00\x00\x00\x00\x00\x00\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x00\x00\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\x00\x00\x00\x00\x00\x00\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x00\x00\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\x7e\x01\x7e\x01\x7e\x01\x7e\x01\x7e\x01\x7e\x01\x7e\x01\x7e\x01\x7e\x01\x7e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\x00\x00\x00\x00\x00\x00\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x00\x00\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x81\x01\x81\x01\x81\x01\x81\x01\x81\x01\x81\x01\x81\x01\x81\x01\x81\x01\x81\x01\x00\x00\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\x82\x01\x82\x01\x82\x01\x82\x01\x82\x01\x82\x01\x82\x01\x82\x01\x82\x01\x82\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\x00\x00\x00\x00\x00\x00\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x83\x01\x83\x01\x83\x01\x83\x01\x83\x01\x83\x01\x83\x01\x83\x01\x83\x01\x83\x01\x00\x00\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\x84\x01\x84\x01\x84\x01\x84\x01\x84\x01\x84\x01\x84\x01\x84\x01\x84\x01\x84\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\x00\x00\x00\x00\x00\x00\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x01\x85\x01\x85\x01\x85\x01\x85\x01\x85\x01\x85\x01\x85\x01\x85\x01\x85\x01\x00\x00\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\x86\x01\x86\x01\x86\x01\x86\x01\x86\x01\x86\x01\x86\x01\x86\x01\x86\x01\x86\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\x00\x00\x00\x00\x00\x00\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x87\x01\x87\x01\x87\x01\x87\x01\x87\x01\x87\x01\x87\x01\x87\x01\x87\x01\x87\x01\x00\x00\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\x88\x01\x88\x01\x88\x01\x88\x01\x88\x01\x88\x01\x88\x01\x88\x01\x88\x01\x88\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\x00\x00\x00\x00\x00\x00\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x01\x89\x01\x89\x01\x89\x01\x89\x01\x89\x01\x89\x01\x89\x01\x89\x01\x89\x01\x00\x00\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\x00\x00\x00\x00\x00\x00\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x00\x00\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\x00\x00\x00\x00\x00\x00\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x00\x00\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\x00\x00\x00\x00\x00\x00\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x65\x01\x65\x01\x65\x01\x65\x01\x65\x01\x65\x01\x65\x01\x65\x01\x65\x01\x65\x01\x00\x00\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x62\x01\x62\x01\x62\x01\x62\x01\x62\x01\x62\x01\x62\x01\x62\x01\x62\x01\x62\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\x00\x00\x00\x00\x00\x00\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\xa1\x01\xa1\x01\xbc\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xbc\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xbc\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xbc\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x00\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x00\x00\x00\x00\x00\x00\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x00\x00\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x00\x00\x00\x00\x00\x00\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x00\x00\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x00\x00\x00\x00\x00\x00\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x00\x00\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x00\x00\x00\x00\x00\x00\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x00\x00\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\xf1\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\xa0\x01\xa1\x01\xa1\x01\xa1\x01\xa2\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x01\xa1\x01\xa1\x01\xa1\x01\xa2\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\xc4\x00\x00\x00\x00\x00\x00\x00\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x00\x00\x00\x00\x00\x00\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x00\x00\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x00\x00\x99\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x00\x00\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\x00\x00\x00\x00\x00\x00\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\x00\x00\x00\x00\x00\x00\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\x00\x00\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa7\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\x00\x00\x00\x00\x00\x00\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\xa8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\x00\x00\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xa9\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\x00\x00\x00\x00\x00\x00\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\xaa\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\x00\x00\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\xab\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\x00\x00\x00\x00\x00\x00\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\xad\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\x00\x00\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xaf\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\x00\x00\x00\x00\x00\x00\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\x00\x00\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\x00\x00\x00\x00\x00\x00\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\x00\x00\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\x00\x00\x00\x00\x00\x00\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\x00\x00\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\x00\x00\x00\x00\x00\x00\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\x00\x00\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\x00\x00\x00\x00\x00\x00\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\x00\x00\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\x00\x00\x00\x00\x00\x00\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\x00\x00\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\x00\x00\x00\x00\x00\x00\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x00\x00\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xa4\x01\xa4\x01\xa4\x01\xc0\x01\xa4\x01\xa4\x01\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x00\x00\x00\x00\x00\x00\xa4\x01\xa4\x01\xa4\x01\xc0\x01\xa4\x01\xa4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\x00\x00\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x64\x01\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x45\x01\x00\x00\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\x61\x01\x00\x00\x00\x00\x00\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x45\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\x00\x00\x44\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\x00\x00\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\x00\x00\x44\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\x00\x00\x00\x00\x00\x00\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\x00\x00\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\x00\x00\x00\x00\x00\x00\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\x00\x00\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\x00\x00\x00\x00\x00\x00\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc9\x01\xc9\x01\xc9\x01\xc9\x01\xc9\x01\xc9\x01\xc9\x01\xc9\x01\xc9\x01\xc9\x01\x00\x00\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc9\x01\xc9\x01\xc9\x01\xc9\x01\xc9\x01\xc9\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\x00\x00\x00\x00\x00\x00\xc9\x01\xc9\x01\xc9\x01\xc9\x01\xc9\x01\xc9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x01\xcc\x01\xcc\x01\xcc\x01\xcc\x01\xcc\x01\xcc\x01\xcc\x01\xcc\x01\xcc\x01\x00\x00\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcc\x01\xcc\x01\xcc\x01\xcc\x01\xcc\x01\xcc\x01\xcd\x01\xcd\x01\xcd\x01\xcd\x01\xcd\x01\xcd\x01\xcd\x01\xcd\x01\xcd\x01\xcd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcd\x01\xcd\x01\xcd\x01\xcd\x01\xcd\x01\xcd\x01\x00\x00\x00\x00\x00\x00\xcc\x01\xcc\x01\xcc\x01\xcc\x01\xcc\x01\xcc\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\x00\x00\xcd\x01\xcd\x01\xcd\x01\xcd\x01\xcd\x01\xcd\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\x00\x00\x00\x00\x00\x00\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\x00\x00\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\x00\x00\x00\x00\x00\x00\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\x00\x00\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\x00\x00\x00\x00\x00\x00\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\x00\x00\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\x00\x00\x00\x00\x00\x00\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\x00\x00\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\x00\x00\x00\x00\x00\x00\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\x00\x00\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\x00\x00\x00\x00\x00\x00\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\x00\x00\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\x00\x00\x00\x00\x00\x00\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\x00\x00\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\x00\x00\x00\x00\x00\x00\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\x00\x00\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\x00\x00\x00\x00\x00\x00\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\x00\x00\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\x00\x00\x00\x00\x00\x00\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\x00\x00\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\x00\x00\x00\x00\x00\x00\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\x00\x00\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\x00\x00\x00\x00\x00\x00\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\x00\x00\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\x00\x00\x00\x00\x00\x00\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\x00\x00\x00\x00\xe8\x01\x00\x00\x00\x00\x00\x00\x66\x01\x66\x01\x66\x01\x66\x01\x66\x01\x66\x01\x66\x01\x66\x01\x66\x01\x66\x01\x00\x00\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\x66\x01\x66\x01\x66\x01\x66\x01\x66\x01\x66\x01\x63\x01\x63\x01\x63\x01\x63\x01\x63\x01\x63\x01\x63\x01\x63\x01\x63\x01\x63\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x01\x63\x01\x63\x01\x63\x01\x63\x01\x63\x01\x00\x00\x00\x00\x00\x00\x66\x01\x66\x01\x66\x01\x66\x01\x66\x01\x66\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x01\x63\x01\x63\x01\x63\x01\x63\x01\x63\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfc\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfe\x00\xfd\x00\x4e\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf5\x00\xf6\x00\x60\x00\xe5\x00\xe5\x00\xe5\x00\xe6\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

alex_check :: AlexAddr
alex_check = AlexA# "\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x79\x00\x65\x00\x79\x00\x73\x00\x67\x00\x73\x00\x65\x00\x6f\x00\x6f\x00\x6f\x00\x79\x00\x65\x00\x41\x00\x41\x00\x67\x00\x67\x00\x79\x00\x41\x00\x20\x00\x67\x00\x22\x00\x67\x00\x67\x00\x67\x00\x35\x00\x65\x00\x28\x00\x29\x00\x31\x00\x32\x00\x33\x00\x65\x00\x35\x00\x6f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x61\x00\x61\x00\x3c\x00\x3d\x00\x3e\x00\x61\x00\x73\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x61\x00\x6f\x00\x4b\x00\x6f\x00\x4d\x00\x67\x00\x61\x00\x50\x00\x69\x00\x52\x00\x53\x00\x54\x00\x55\x00\x67\x00\x67\x00\x41\x00\x65\x00\x32\x00\x69\x00\x69\x00\x35\x00\x69\x00\x49\x00\x69\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x53\x00\x69\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x31\x00\x72\x00\x73\x00\x74\x00\x75\x00\x69\x00\x6d\x00\x61\x00\x52\x00\x65\x00\x6b\x00\x61\x00\x69\x00\x79\x00\x69\x00\x6d\x00\x69\x00\x69\x00\x61\x00\x65\x00\x65\x00\x65\x00\x53\x00\x65\x00\x73\x00\x65\x00\x6f\x00\x53\x00\x4b\x00\x53\x00\x53\x00\x69\x00\x53\x00\x53\x00\x31\x00\x49\x00\x69\x00\x67\x00\x61\x00\x61\x00\x72\x00\x73\x00\x69\x00\x69\x00\x79\x00\x75\x00\x67\x00\x73\x00\x73\x00\x61\x00\x73\x00\x67\x00\x6b\x00\x61\x00\x73\x00\x65\x00\x63\x00\x63\x00\x67\x00\x73\x00\x6b\x00\x73\x00\x73\x00\x67\x00\x73\x00\x73\x00\x61\x00\x69\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\xbc\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x41\x00\x41\x00\x41\x00\x41\x00\x4b\x00\x47\x00\x43\x00\x43\x00\x43\x00\x43\x00\x41\x00\x65\x00\x6f\x00\x6f\x00\x6f\x00\x6d\x00\x65\x00\x65\x00\x65\x00\x73\x00\x4d\x00\x61\x00\x61\x00\x69\x00\x69\x00\x69\x00\x69\x00\x69\x00\x61\x00\x65\x00\x61\x00\x75\x00\x61\x00\x61\x00\x61\x00\x61\x00\x6b\x00\x67\x00\x63\x00\x63\x00\x63\x00\x63\x00\x61\x00\x6f\x00\x79\x00\x73\x00\x61\x00\x65\x00\x65\x00\x69\x00\x61\x00\x61\x00\x6d\x00\x69\x00\x76\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\xbc\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x4b\x00\x4b\x00\x4f\x00\x45\x00\x6d\x00\x61\x00\x73\x00\x67\x00\x69\x00\x63\x00\x69\x00\x69\x00\x63\x00\x63\x00\x73\x00\x79\x00\x65\x00\x65\x00\x6f\x00\x63\x00\x6f\x00\x79\x00\x6f\x00\x6f\x00\x4b\x00\x65\x00\x65\x00\x65\x00\x6d\x00\x65\x00\x65\x00\x65\x00\x6b\x00\x6b\x00\x6f\x00\x65\x00\x6f\x00\x6f\x00\x69\x00\x72\x00\x72\x00\x65\x00\x65\x00\x69\x00\x65\x00\x65\x00\x6d\x00\x61\x00\x79\x00\x75\x00\x69\x00\x61\x00\x79\x00\x44\x00\x62\x00\x74\x00\x6b\x00\x52\x00\x74\x00\x52\x00\x72\x00\x72\x00\x72\x00\x42\x00\x42\x00\x6e\x00\x50\x00\x6c\x00\x6c\x00\x76\x00\x76\x00\x76\x00\x72\x00\x74\x00\x6e\x00\x6e\x00\x6e\x00\x6e\x00\x74\x00\x74\x00\x52\x00\x64\x00\x64\x00\x72\x00\x74\x00\x64\x00\x74\x00\x74\x00\x6e\x00\x72\x00\x72\x00\x72\x00\x76\x00\x6e\x00\x64\x00\x62\x00\x62\x00\x6e\x00\x70\x00\x6e\x00\x70\x00\x6e\x00\x6e\x00\x6c\x00\x68\x00\x62\x00\x74\x00\x72\x00\x38\x00\x36\x00\x72\x00\x6e\x00\x72\x00\x72\x00\x70\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\xbc\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x74\x00\x44\x00\x6e\x00\x6e\x00\x6e\x00\x6c\x00\x54\x00\x50\x00\x6e\x00\x6c\x00\x50\x00\x54\x00\x6c\x00\x6c\x00\x54\x00\x74\x00\x6e\x00\x7a\x00\x74\x00\x6c\x00\x78\x00\x72\x00\x72\x00\x72\x00\x72\x00\x6e\x00\x72\x00\x6e\x00\x70\x00\x64\x00\x68\x00\x70\x00\x72\x00\x64\x00\x34\x00\x32\x00\x34\x00\x6e\x00\x74\x00\x70\x00\x6e\x00\x36\x00\x70\x00\x74\x00\x30\x00\x6c\x00\x74\x00\x74\x00\x76\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x48\x00\x74\x00\x48\x00\x74\x00\x44\x00\x44\x00\x74\x00\x74\x00\x6e\x00\x6e\x00\x66\x00\x74\x00\x3d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x64\x00\x6e\x00\xff\xff\xff\xff\xff\xff\x72\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x68\x00\x69\x00\x68\x00\x69\x00\x64\x00\x64\x00\x79\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x74\x00\x75\x00\x74\x00\x75\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x0a\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\x42\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x22\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x53\x00\xff\xff\xff\xff\x52\x00\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x62\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x73\x00\xff\xff\xff\xff\x72\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\xbc\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x78\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\xff\xff\xff\xff\xff\xff\xff\xff\x76\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\x69\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\x6e\x00\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x72\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\x53\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\x68\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x73\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x53\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\x22\x00\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\xbc\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

alex_deflt :: AlexAddr
alex_deflt = AlexA# "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x00\xf5\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfe\x00\xfe\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x11\x01\x11\x01\x11\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x11\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x11\x01"#

alex_accept = listArray (0::Int,488) [AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccNone,AlexAccSkip,AlexAcc (alex_action_1),AlexAcc (alex_action_2),AlexAcc (alex_action_3),AlexAcc (alex_action_4),AlexAcc (alex_action_5),AlexAcc (alex_action_6),AlexAcc (alex_action_7),AlexAcc (alex_action_8),AlexAcc (alex_action_9),AlexAcc (alex_action_10),AlexAcc (alex_action_11),AlexAcc (alex_action_12),AlexAcc (alex_action_13),AlexAcc (alex_action_14),AlexAcc (alex_action_15),AlexAcc (alex_action_16),AlexAcc (alex_action_17),AlexAcc (alex_action_18),AlexAcc (alex_action_19),AlexAcc (alex_action_20),AlexAcc (alex_action_21),AlexAcc (alex_action_22),AlexAcc (alex_action_23),AlexAcc (alex_action_24),AlexAcc (alex_action_25),AlexAcc (alex_action_26),AlexAcc (alex_action_27),AlexAcc (alex_action_28),AlexAcc (alex_action_29),AlexAcc (alex_action_30),AlexAcc (alex_action_31),AlexAcc (alex_action_32),AlexAcc (alex_action_33),AlexAcc (alex_action_34),AlexAcc (alex_action_35),AlexAcc (alex_action_36),AlexAcc (alex_action_37),AlexAcc (alex_action_38),AlexAcc (alex_action_39),AlexAcc (alex_action_40),AlexAcc (alex_action_41),AlexAcc (alex_action_42),AlexAcc (alex_action_43),AlexAcc (alex_action_44),AlexAcc (alex_action_45),AlexAcc (alex_action_46),AlexAcc (alex_action_47),AlexAcc (alex_action_48),AlexAcc (alex_action_49),AlexAcc (alex_action_50),AlexAcc (alex_action_51),AlexAcc (alex_action_52),AlexAcc (alex_action_53),AlexAcc (alex_action_54),AlexAcc (alex_action_55),AlexAcc (alex_action_56),AlexAcc (alex_action_57),AlexAcc (alex_action_58),AlexAcc (alex_action_58),AlexAcc (alex_action_59),AlexAcc (alex_action_60),AlexAcc (alex_action_60),AlexAcc (alex_action_61),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_62),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_63),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_64),AlexAcc (alex_action_65)]
{-# LINE 97 "HOpenPGP/Tools/Lexer.x" #-}

data Token
  = TokenTag
  | TokenAnd
  | TokenAny
  | TokenNot
  | TokenOr
  | TokenInt Integer
  | TokenEq
  | TokenLt
  | TokenGt
  | TokenLParen
  | TokenRParen
  | TokenEOF
  | TokenPKVersion
  | TokenSigVersion
  | TokenSigType
  | TokenPKAlgo
  | TokenSigPKAlgo
  | TokenHashAlgo
  | TokenRSA
  | TokenDSA
  | TokenElgamal
  | TokenECDSA
  | TokenECDH
  | TokenDH
  | TokenBinary
  | TokenCanonicalText
  | TokenStandalone
  | TokenGenericCert
  | TokenPersonaCert
  | TokenCasualCert
  | TokenPositiveCert
  | TokenSubkeyBindingSig
  | TokenPrimaryKeyBindingSig
  | TokenSignatureDirectlyOnAKey
  | TokenKeyRevocationSig
  | TokenSubkeyRevocationSig
  | TokenCertRevocationSig
  | TokenTimestampSig
  | TokenMD5
  | TokenSHA1
  | TokenRIPEMD160
  | TokenSHA256
  | TokenSHA384
  | TokenSHA512
  | TokenSHA224
  | TokenKeysize
  | TokenTimestamp
  | TokenFingerprint
  | TokenKeyID
  | TokenFpr TwentyOctetFingerprint
  | TokenLongID (Either String EightOctetKeyId)
  | TokenLength
  | TokenEvery
  | TokenOne
  | TokenOf
  | TokenContains
  | TokenUids
  | TokenStr String
  | TokenA
  | TokenSubkey
  deriving (Eq,Show)

alexEOF = return TokenEOF

lex :: (String -> a) -> AlexAction a
lex f = \(_,_,_,s) i -> return (f (take i s))

lex' :: a -> AlexAction a
lex' = lex . const


alex_action_1 =  lex' TokenA 
alex_action_2 =  lex' TokenAnd 
alex_action_3 =  lex' TokenAny 
alex_action_4 =  lex' TokenEvery 
alex_action_5 =  lex' TokenNot 
alex_action_6 =  lex' TokenOne 
alex_action_7 =  lex' TokenOr 
alex_action_8 =  lex' TokenSubkey 
alex_action_9 =  lex' TokenTag 
alex_action_10 =  lex' TokenOf 
alex_action_11 =  lex' TokenEq 
alex_action_12 =  lex' TokenEq 
alex_action_13 =  lex' TokenEq 
alex_action_14 =  lex' TokenLt 
alex_action_15 =  lex' TokenGt 
alex_action_16 =  lex' TokenLParen 
alex_action_17 =  lex' TokenRParen 
alex_action_18 =  lex' TokenContains 
alex_action_19 =  lex' TokenPKVersion 
alex_action_20 =  lex' TokenSigVersion 
alex_action_21 =  lex' TokenSigType 
alex_action_22 =  lex' TokenPKAlgo 
alex_action_23 =  lex' TokenSigPKAlgo 
alex_action_24 =  lex' TokenHashAlgo 
alex_action_25 =  lex' TokenRSA 
alex_action_26 =  lex' TokenDSA 
alex_action_27 =  lex' TokenElgamal 
alex_action_28 =  lex' TokenECDSA 
alex_action_29 =  lex' TokenECDH 
alex_action_30 =  lex' TokenDH 
alex_action_31 =  lex' TokenBinary 
alex_action_32 =  lex' TokenCanonicalText 
alex_action_33 =  lex' TokenStandalone 
alex_action_34 =  lex' TokenGenericCert 
alex_action_35 =  lex' TokenPersonaCert 
alex_action_36 =  lex' TokenCasualCert 
alex_action_37 =  lex' TokenPositiveCert 
alex_action_38 =  lex' TokenSubkeyBindingSig 
alex_action_39 =  lex' TokenPrimaryKeyBindingSig 
alex_action_40 =  lex' TokenSignatureDirectlyOnAKey 
alex_action_41 =  lex' TokenKeyRevocationSig 
alex_action_42 =  lex' TokenSubkeyRevocationSig 
alex_action_43 =  lex' TokenCertRevocationSig 
alex_action_44 =  lex' TokenTimestampSig 
alex_action_45 =  lex' TokenMD5 
alex_action_46 =  lex' TokenSHA1 
alex_action_47 =  lex' TokenRIPEMD160 
alex_action_48 =  lex' TokenSHA256 
alex_action_49 =  lex' TokenSHA384 
alex_action_50 =  lex' TokenSHA512 
alex_action_51 =  lex' TokenSHA224 
alex_action_52 =  lex' TokenUids 
alex_action_53 =  lex' TokenKeysize 
alex_action_54 =  lex' TokenLength 
alex_action_55 =  lex' TokenTimestamp 
alex_action_56 =  lex' TokenFingerprint 
alex_action_57 =  lex' TokenKeyID 
alex_action_58 =  lex (TokenFpr . read) 
alex_action_59 =  lex (TokenFpr . read . drop 2) 
alex_action_60 =  lex (TokenLongID . Right . read) 
alex_action_61 =  lex (TokenLongID . Right . read . drop 2) 
alex_action_62 =  lex (TokenInt  . fromIntegral . read) 
alex_action_63 =  lex (TokenInt  . fromIntegral . fst . head . readHex) 
alex_action_64 =  lex (TokenInt  . fromIntegral . fst . head . readHex . drop 2) 
alex_action_65 =  lex (TokenStr . reverse . drop 1 . reverse . drop 1) 
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 1 "<command-line>" #-}
{-# LINE 9 "<command-line>" #-}
# 1 "/usr/include/stdc-predef.h" 1 3 4

# 17 "/usr/include/stdc-predef.h" 3 4










































{-# LINE 9 "<command-line>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- -----------------------------------------------------------------------------
-- ALEX TEMPLATE
--
-- This code is in the PUBLIC DOMAIN; you may copy it freely and use
-- it for any purpose whatsoever.

-- -----------------------------------------------------------------------------
-- INTERNALS and main scanner engine

{-# LINE 21 "templates/GenericTemplate.hs" #-}





-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define GTE(n,m) (tagToEnum# (n >=# m))
#define EQ(n,m) (tagToEnum# (n ==# m))
#else
#define GTE(n,m) (n >=# m)
#define EQ(n,m) (n ==# m)
#endif
{-# LINE 51 "templates/GenericTemplate.hs" #-}


data AlexAddr = AlexA# Addr#
-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ < 503
uncheckedShiftL# = shiftL#
#endif

{-# INLINE alexIndexInt16OffAddr #-}
alexIndexInt16OffAddr (AlexA# arr) off =
#ifdef WORDS_BIGENDIAN
  narrow16Int# i
  where
        i    = word2Int# ((high `uncheckedShiftL#` 8#) `or#` low)
        high = int2Word# (ord# (indexCharOffAddr# arr (off' +# 1#)))
        low  = int2Word# (ord# (indexCharOffAddr# arr off'))
        off' = off *# 2#
#else
  indexInt16OffAddr# arr off
#endif





{-# INLINE alexIndexInt32OffAddr #-}
alexIndexInt32OffAddr (AlexA# arr) off = 
#ifdef WORDS_BIGENDIAN
  narrow32Int# i
  where
   i    = word2Int# ((b3 `uncheckedShiftL#` 24#) `or#`
		     (b2 `uncheckedShiftL#` 16#) `or#`
		     (b1 `uncheckedShiftL#` 8#) `or#` b0)
   b3   = int2Word# (ord# (indexCharOffAddr# arr (off' +# 3#)))
   b2   = int2Word# (ord# (indexCharOffAddr# arr (off' +# 2#)))
   b1   = int2Word# (ord# (indexCharOffAddr# arr (off' +# 1#)))
   b0   = int2Word# (ord# (indexCharOffAddr# arr off'))
   off' = off *# 4#
#else
  indexInt32OffAddr# arr off
#endif






#if __GLASGOW_HASKELL__ < 503
quickIndex arr i = arr ! i
#else
-- GHC >= 503, unsafeAt is available from Data.Array.Base.
quickIndex = unsafeAt
#endif




-- -----------------------------------------------------------------------------
-- Main lexing routines

data AlexReturn a
  = AlexEOF
  | AlexError  !AlexInput
  | AlexSkip   !AlexInput !Int
  | AlexToken  !AlexInput !Int a

-- alexScan :: AlexInput -> StartCode -> AlexReturn a
alexScan input (I# (sc))
  = alexScanUser undefined input (I# (sc))

alexScanUser user input (I# (sc))
  = case alex_scan_tkn user input 0# input sc AlexNone of
	(AlexNone, input') ->
		case alexGetByte input of
			Nothing -> 



				   AlexEOF
			Just _ ->



				   AlexError input'

	(AlexLastSkip input'' len, _) ->



		AlexSkip input'' len

	(AlexLastAcc k input''' len, _) ->



		AlexToken input''' len k


-- Push the input through the DFA, remembering the most recent accepting
-- state it encountered.

alex_scan_tkn user orig_input len input s last_acc =
  input `seq` -- strict in the input
  let 
	new_acc = (check_accs (alex_accept `quickIndex` (I# (s))))
  in
  new_acc `seq`
  case alexGetByte input of
     Nothing -> (new_acc, input)
     Just (c, new_input) -> 



      case fromIntegral c of { (I# (ord_c)) ->
        let
                base   = alexIndexInt32OffAddr alex_base s
                offset = (base +# ord_c)
                check  = alexIndexInt16OffAddr alex_check offset
		
                new_s = if GTE(offset,0#) && EQ(check,ord_c)
			  then alexIndexInt16OffAddr alex_table offset
			  else alexIndexInt16OffAddr alex_deflt s
	in
        case new_s of
	    -1# -> (new_acc, input)
		-- on an error, we want to keep the input *before* the
		-- character that failed, not after.
    	    _ -> alex_scan_tkn user orig_input (if c < 0x80 || c >= 0xC0 then (len +# 1#) else len)
                                                -- note that the length is increased ONLY if this is the 1st byte in a char encoding)
			new_input new_s new_acc
      }
  where
	check_accs (AlexAccNone) = last_acc
	check_accs (AlexAcc a  ) = AlexLastAcc a input (I# (len))
	check_accs (AlexAccSkip) = AlexLastSkip  input (I# (len))
{-# LINE 198 "templates/GenericTemplate.hs" #-}

data AlexLastAcc a
  = AlexNone
  | AlexLastAcc a !AlexInput !Int
  | AlexLastSkip  !AlexInput !Int

instance Functor AlexLastAcc where
    fmap f AlexNone = AlexNone
    fmap f (AlexLastAcc x y z) = AlexLastAcc (f x) y z
    fmap f (AlexLastSkip x y) = AlexLastSkip x y

data AlexAcc a user
  = AlexAccNone
  | AlexAcc a
  | AlexAccSkip
{-# LINE 242 "templates/GenericTemplate.hs" #-}

-- used by wrappers
iUnbox (I# (i)) = i
