# ========================== begin_copyright_notice ============================
#
# Copyright (C) 2017-2021 Intel Corporation
#
# SPDX-License-Identifier: MIT
#
# =========================== end_copyright_notice =============================

############# Currently Supported Types ######################
#PointerTypes = ["ptr_private","ptr_global","ptr_constant","ptr_local","ptr_generic"]
#FloatingPointTypes = ["half","float","double"]
#IntegerTypes = ["bool","char","short","int","long"]
#IntrinsicsProperties = ["None","NoMem","ReadArgMem","ReadMem","ReadWriteArgMem",
#                        "WriteMem", "NoReturn","NoDuplicate", "Convergent"]
#IntrinsicsProperties may be specified as a comma separated list (e.g., "Convergent,NoMem")

# EX
# "GenISA_blah": ["Description goes here",
#     [(return_type,                        "comment on return value"),
#     [(arg_type,                           "comment on arg value")],
#     Property]],

#The "any" type can be followed by a default type if a type is not
#explicitly specified: Ex. "any:int"

# 0 - LLVMMatchType<0>
# 1 - LLVMMatchType<1>
# {int} - LLVMMatchType<{int}>
# See Intrinsics.json file for entries

#### Update helper functions in Source/IGC/Compiler/CISACodeGen/helper.h when adding a new intrinsic
#    if required.
#    For example: Update IsStatelessMemLoadIntrinsic, IsStatelessMemStoreIntrinsic and
#    IsStatelessMemAtomicIntrinsic if it is a stateless memory read/write intrinsic.

Imported_Intrinsics = \
{
####################################################################################################
"GenISA_2fto2bf": ["",
    [("anyint",                        ""),
    [("anyfloat",                      ""),
     (1,                               ""),
     ("int",                           "")],
    "NoMem"]],
####################################################################################################
"GenISA_assume_uniform": ["used by compiler to mark a uniform private array",
    [("void",                          "return nothing"),
    [("anyptr",                        "ptr")],
    "None"]],
####################################################################################################
"GenISA_bftof": ["Convert bf16 to float",
    [("anyfloat",                      "float result"),
    [("anyint",                        "bf16 source")],
    "NoMem"]],
####################################################################################################
"GenISA_CatchAllDebugLine": ["",
    [("void",                          ""),
    [],
    "InaccessibleMemOnly"]],
####################################################################################################
"GenISA_DCL_DSCntrlPtInputVec": ["",
    [("float4",                        "input reg (generated by this intrin)"),
    [("int",                           "vertex index"),
     ("int",                           "element index")],
    "NoMem"]],
####################################################################################################
"GenISA_DCL_DSInputTessFactor": ["",
    [("float",                         "input reg (generated by this intrin)"),
    [("int",                           "system interpreted tessellation factor")],
    "NoMem"]],
####################################################################################################
"GenISA_DCL_DSPatchConstInputVec": ["",
    [("float4",                        "input reg (generated by this intrin)"),
    [("int",                           "input index")],
    "NoMem"]],
####################################################################################################
"GenISA_DCL_GSinputVec": ["",
    [("float4",                        "input reg (generated by this intrin)"),
    [("int",                           "Vertex Idx"),
     ("int",                           "Attribute Idx")],
    "NoMem"]],
####################################################################################################
"GenISA_DCL_GSsystemValue": ["",
    [("float",                         "input reg (generated by this intrin)"),
    [("int",                           "vertex idx"),
     ("int",                           "usage")],
    "NoMem"]],
####################################################################################################
"GenISA_DCL_HSControlPointID": ["",
    [("int",                           "output"),
    [],
    "None"]],
####################################################################################################
"GenISA_DCL_HSOutputCntrlPtInputVec": ["",
    [("float4",                        "input reg (generated by this intrin)"),
    [("int",                           "owordVertexIndex"),
     ("int",                           "owordAttributeIndex")],
    "ReadMem"]],
####################################################################################################
"GenISA_DCL_HSPatchConstInputVec": ["",
    [("float4",                        "input reg (generated by this intrin)"),
    [("int",                           "owordAttributeIndex")],
    "ReadMem"]],
####################################################################################################
"GenISA_DCL_HSinputVec": ["",
    [("float4",                        "input reg (generated by this intrin)"),
    [("int",                           "Vertex Idx"),
     ("int",                           "Attribute Idx")],
    "NoMem"]],
####################################################################################################
"GenISA_DCL_ShaderInputVec": ["",
    [("anyvector",                     "input reg (generated by this intrin)"),
    [("int",                           "dwordAttributeOrSetupIndex"),
     ("int",                           "interpolation mode: e_interpolation_PSOnly")],
    "NoMem"]],
####################################################################################################
"GenISA_DCL_SystemValue": ["",
    [("any:float",                     "input reg (generated by this intrin)"),
    [("int",                           "usage")],
    "NoMem"]],
####################################################################################################
"GenISA_DCL_input": ["",
    [("int",                           "scalar input reg"),
    [("int",                           "type (texture (t#) or vFace"),
     ("int",                           "index")],
    "None"]],
####################################################################################################
"GenISA_DCL_inputVec": ["",
    [("anyfloat",                      "input reg (generated by this intrin)"),
    [("int",                           "input index"),
     ("int",                           "interpolation mode")],
    "NoMem"]],
####################################################################################################
"GenISA_dpas": ["",
    [("anyvector",                     ""),
    [("anyvector",                     ""),
     ("anyvector",                     ""),
     ("anyvector",                     ""),
     ("int",                           ""),
     ("int",                           ""),
     ("int",                           ""),
     ("int",                           ""),
     ("bool",                          "")],
    "Convergent","NoMem"]],
####################################################################################################
"GenISA_EndPrimitive": ["",
    [("void",                          ""),
    [("int",                           "emitCount")],
    "None"]],
####################################################################################################
"GenISA_ftobf": ["Convert from float to bf16",
    [("anyint",                        "bf16 result"),
    [("anyfloat",                      "float source"),
     ("int",                           "Rounding mode (ERoundingMode)")],
    "NoMem"]],
####################################################################################################
"GenISA_GetBufferPtr": ["",
    [("anyptr",                        "result"),
    [("int",                           "Resource index"),
     ("int",                           "Resource Type (CB, UAV, etc")],
    "NoMem"]],
####################################################################################################
"GenISA_GetPixelMask": ["Get live pixel mask from dmask",
    [("bool",                          ""),
    [("bool",                          "")],
    "None"]],
####################################################################################################
"GenISA_GradientX": ["",
    [("anyfloat",                      "result"),
    [(0,                               "coordinates x")],
    "NoMem"]],
####################################################################################################
"GenISA_GradientXfine": ["",
    [("anyfloat",                      "result"),
    [(0,                               "coordinates x")],
    "NoMem"]],
####################################################################################################
"GenISA_GradientY": ["",
    [("anyfloat",                      "result"),
    [(0,                               "coordinates y")],
    "NoMem"]],
####################################################################################################
"GenISA_GradientYfine": ["",
    [("anyfloat",                      "result"),
    [(0,                               "coordinates y")],
    "NoMem"]],
####################################################################################################
"GenISA_GsCutControlHeader": ["",
    [("void",                          ""),
    [("int",                           "DWORD 1"),
     ("int",                           "DWORD 2"),
     ("int",                           "DWORD 3"),
     ("int",                           "DWORD 4"),
     ("int",                           "DWORD 5"),
     ("int",                           "DWORD 6"),
     ("int",                           "DWORD 7"),
     ("int",                           "DWORD 8"),
     ("int",                           "DWORD 9"),
     ("int",                           "DWORD 10"),
     ("int",                           "DWORD 11"),
     ("int",                           "DWORD 12"),
     ("int",                           "DWORD 13"),
     ("int",                           "DWORD 14"),
     ("int",                           "DWORD 15"),
     ("int",                           "DWORD 16"),
     ("int",                           "emitCount")],
    "None"]],
####################################################################################################
"GenISA_GsStreamHeader": ["",
    [("void",                          "DWORD 1"),
    [("int",                           "DWORD 2"),
     ("int",                           "DWORD 3"),
     ("int",                           "DWORD 4"),
     ("int",                           "DWORD 5"),
     ("int",                           "DWORD 6"),
     ("int",                           "DWORD 7"),
     ("int",                           "DWORD 8"),
     ("int",                           "DWORD 9"),
     ("int",                           "DWORD 10"),
     ("int",                           "DWORD 11"),
     ("int",                           "DWORD 12"),
     ("int",                           "DWORD 13"),
     ("int",                           "DWORD 14"),
     ("int",                           "DWORD 15"),
     ("int",                           "DWORD 16"),
     ("int",                           "DWORD 17"),
     ("int",                           "DWORD 18"),
     ("int",                           "DWORD 19"),
     ("int",                           "DWORD 20"),
     ("int",                           "DWORD 21"),
     ("int",                           "DWORD 22"),
     ("int",                           "DWORD 23"),
     ("int",                           "DWORD 24"),
     ("int",                           "DWORD 25"),
     ("int",                           "DWORD 26"),
     ("int",                           "DWORD 27"),
     ("int",                           "DWORD 28"),
     ("int",                           "DWORD 29"),
     ("int",                           "DWORD 30"),
     ("int",                           "DWORD 31"),
     ("int",                           "DWORD 32"),
     ("int",                           "DWORD 33"),
     ("int",                           "DWORD 34"),
     ("int",                           "DWORD 35"),
     ("int",                           "DWORD 36"),
     ("int",                           "DWORD 37"),
     ("int",                           "DWORD 38"),
     ("int",                           "DWORD 39"),
     ("int",                           "DWORD 40"),
     ("int",                           "DWORD 41"),
     ("int",                           "DWORD 42"),
     ("int",                           "DWORD 43"),
     ("int",                           "DWORD 44"),
     ("int",                           "DWORD 45"),
     ("int",                           "DWORD 46"),
     ("int",                           "DWORD 47"),
     ("int",                           "DWORD 48"),
     ("int",                           "DWORD 49"),
     ("int",                           "DWORD 50"),
     ("int",                           "DWORD 51"),
     ("int",                           "DWORD 52"),
     ("int",                           "DWORD 53"),
     ("int",                           "DWORD 54"),
     ("int",                           "DWORD 55"),
     ("int",                           "DWORD 56"),
     ("int",                           "DWORD 57"),
     ("int",                           "DWORD 58"),
     ("int",                           "DWORD 59"),
     ("int",                           "DWORD 60"),
     ("int",                           "DWORD 61"),
     ("int",                           "DWORD 62"),
     ("int",                           "DWORD 63"),
     ("int",                           "DWORD 64"),
     ("int",                           "Emit count"),
     ("int",                           "")],
    "None"]],
####################################################################################################
"GenISA_HSURBPatchHeaderRead": ["",
    [("float8",                        "result"),
    [],
    "ReadMem"]],
####################################################################################################
"GenISA_IEEE_Divide": ["Correctly Rounded divide instrinsic -> produces ISA_DIVM",
    [("anyfloat",                      "output"),
    [(0,                               "src0"),
     (0,                               "src1")],
    "NoMem"]],
####################################################################################################
"GenISA_IEEE_Sqrt": ["Correctly Rounded sqrt instrinsic -> produces ISA_SQRTM",
    [("float",                         "output"),
    [("float",                         "src0")],
    "NoMem"]],
####################################################################################################
"GenISA_InitDiscardMask": ["",
    [("bool",                          ""),
    [],
    "None"]],
####################################################################################################
"GenISA_InnerScalarTessFactors": ["",
    [("void",                          ""),
    [("int",                           "enum for the type of Tess factor"),
     ("float",                         "tess factor value")],
    "None"]],
####################################################################################################
"GenISA_Interpolant": ["",
    [("float4",                        ""),
    [("int",                           "")],
    "NoMem"]],
####################################################################################################
"GenISA_Interpolate": ["",
    [("float",                         ""),
    [("int",                           "input index"),
     ("float2",                        "bary")],
    "NoMem"]],
####################################################################################################
"GenISA_Interpolate2": ["",
    [("float",                         ""),
    [("float4",                        ""),
     ("float2",                        "")],
    "NoMem"]],
####################################################################################################
"GenISA_IsHelperInvocation": ["Check whether invocation is a helper invocation",
    [("bool",                          ""),
    [("void",                          "")],
    "Convergent,InaccessibleMemOnly"]],
####################################################################################################
"GenISA_MediaBlockRead": ["",
    [("anyint",                        ""),
    [("int",                           "image id"),
     ("int",                           "x offset"),
     ("int",                           "y offset"),
     ("int",                           "isUAV"),
     ("int",                           "width"),
     ("int",                           "height")],
    "None"]],
####################################################################################################
"GenISA_MediaBlockRectangleRead": ["",
    [("void",                          ""),
    [("int",                           "image"),
     ("int",                           "xOffset"),
     ("int",                           "yOffset"),
     ("int",                           "isUAV"),
     ("int",                           "blockWidth"),
     ("int",                           "blockHeight"),
     ("int",                           "destination blob")],
    "None"]],
####################################################################################################
"GenISA_MediaBlockWrite": ["",
    [("void",                          ""),
    [("int",                           "image id"),
     ("int",                           "x offset"),
     ("int",                           "y offset"),
     ("int",                           "isUAV"),
     ("int",                           "width"),
     ("int",                           "height"),
     ("anyint",                        "pixels")],
    "None"]],
####################################################################################################
"GenISA_OUTPUT": ["",
    [("void",                          ""),
    [("anyfloat",                      "0: source x"),
     (0,                               "1: source y"),
     (0,                               "2: source z"),
     (0,                               "3: source w"),
     ("int",                           "4: usage (color/texcoord/pos)"),
     ("int",                           "5: index & mask")],
    "NoDuplicate"]],
####################################################################################################
"GenISA_OUTPUTGS": ["",
    [("void",                          ""),
    [("float",                         "x"),
     ("float",                         "y"),
     ("float",                         "z"),
     ("float",                         "w"),
     ("int",                           "type"),
     ("int",                           "idx_mask"),
     ("int",                           "emitCount")],
    "None"]],
####################################################################################################
"GenISA_OUTPUTGS2": ["",
    [("void",                          ""),
    [("float",                         "x"),
     ("float",                         "y"),
     ("float",                         "z"),
     ("float",                         "w"),
     ("float",                         "x2"),
     ("float",                         "y2"),
     ("float",                         "z2"),
     ("float",                         "w2"),
     ("int",                           "type"),
     ("int",                           "idx_mask"),
     ("int",                           "emitCount")],
    "None"]],
####################################################################################################
"GenISA_OuterScalarTessFactors": ["",
    [("void",                          ""),
    [("int",                           "enum for the type of Tess factor"),
     ("float",                         "tess factor value")],
    "None"]],
####################################################################################################
"GenISA_OutputTessControlPoint": ["",
    [("void",                          ""),
    [("float",                         "source x"),
     ("float",                         "source y"),
     ("float",                         "source z"),
     ("float",                         "source w"),
     ("int",                           "index"),
     ("int",                           "cpid"),
     ("int",                           "mask")],
    "None"]],
####################################################################################################
"GenISA_OutputTessFactors": ["",
    [("void",                          ""),
    [("float",                         "QUAD_V_INSIDE_TESSFACTOR"),
     ("float",                         "QUAD_U_INSIDE_TESSFACTOR"),
     ("float",                         "QUAD_V_EQ_1_EDGE_TESSFACTOR, TRI_INSIDE_TESSFACTOR"),
     ("float",                         "QUAD_U_EQ_1_EDGE_TESSFACTOR, TRI_W_EQ_0_EDGE_TESSFACTOR"),
     ("float",                         "QUAD_V_EQ_0_EDGE_TESSFACTOR, TRI_V_EQ_0_EDGE_TESSFACTOR, "+\
                                       "LINE_DENSITY_TESSFACTOR"),
     ("float",                         "QUAD_U_EQ_0_EDGE_TESSFACTOR, TRI_U_EQ_0_EDGE_TESSFACTOR, "+\
                                       "LINE_DETAIL_TESSFACTOR")],
    "None"]],
####################################################################################################
"GenISA_PHASE_INPUT": ["",
    [("anyfloat",                      ""),
    [("int",                           "index")],
    "NoMem"]],
####################################################################################################
"GenISA_PHASE_INPUTVEC": ["",
    [("anyfloat",                      ""),
    [("int",                           ""),
     ("short",                         ""),
     ("short",                         "")],
    "NoMem"]],
####################################################################################################
"GenISA_PHASE_OUTPUT": ["",
    [("void",                          ""),
    [("anyfloat",                      "source x"),
     ("int",                           "index")],
    "None"]],
####################################################################################################
"GenISA_PHASE_OUTPUTVEC": ["",
    [("void",                          ""),
    [("anyvector",                     ""),
     ("int",                           "")],
    "None"]],
####################################################################################################
"GenISA_PatchConstantOutput": ["",
    [("void",                          ""),
    [("anyfloat",                      "source x"),
     (0,                               "source y"),
     (0,                               "source z"),
     (0,                               "source w"),
     ("int",                           "index"),
     ("int",                           "mask")],
    "None"]],
####################################################################################################
"GenISA_PixelPositionX": ["",
    [("short",                         ""),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_PixelPositionY": ["",
    [("short",                         ""),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_PullCentroidBarys": ["",
    [("float2",                        ""),
    [("bool",                          "")],
    "NoMem"]],
####################################################################################################
"GenISA_PullSampleIndexBarys": ["",
    [("float2",                        ""),
    [("int",                           "sample index"),
     ("bool",                          "perspective")],
    "NoMem"]],
####################################################################################################
"GenISA_PullSnappedBarys": ["",
    [("float2",                        ""),
    [("int",                           "x offset"),
     ("int",                           "y offset"),
     ("bool",                          "perspective")],
    "NoMem"]],
####################################################################################################
"GenISA_QuadPrefix": ["",
    [("anyint",                        ""),
    [(0,                               ""),
     ("char",                          ""),
     ("bool",                          "")],
    "Convergent,InaccessibleMemOnly"]],
####################################################################################################
"GenISA_ROUNDNE": ["",
    [("float",                         "result"),
    [("float",                         "source")],
    "NoMem"]],
####################################################################################################
"GenISA_RTDualBlendSource": ["",
    [("void",                          ""),
    [("float",                         "0: oMask TODO: should be i32"),
     ("bool",                          "1: pMask"),
     ("anyfloat",                      "2: Red0"),
     (0,                               "3: Green0"),
     (0,                               "4: Blue0"),
     (0,                               "5: Alpha0"),
     (0,                               "6: Red1"),
     (0,                               "7: Green1"),
     (0,                               "8: Blue1"),
     (0,                               "9: Alpha1"),
     ("float",                         "10: depth"),
     ("float",                         "11: stencil"),
     ("int",                           "12: RT index"),
     ("bool",                          "13: has mask"),
     ("bool",                          "14: has depth"),
     ("bool",                          "15: has stencil"),
     ("bool",                          "16: per sample"),
     ("int",                           "17: sample index")],
    "None"]],
####################################################################################################
"GenISA_RTWrite": ["",
    [("void",                          ""),
    [("anyfloat",                      "0: src0 Alpha"),
     ("float",                         "1: oMask TODO: should be i32"),
     ("bool",                          "2: pMask"),
     (0,                               "3: Red"),
     (0,                               "4: Green"),
     (0,                               "5: Blue"),
     (0,                               "6: Alpha"),
     ("float",                         "7: depth"),
     ("float",                         "8: stencil"),
     ("int",                           "9: RT index"),
     ("int",                           "10: Blend state index"),
     ("bool",                          "11: has mask"),
     ("bool",                          "12: has depth"),
     ("bool",                          "13: has stencil"),
     ("bool",                          "14: per sample"),
     ("int",                           "15: sample index")],
    "None"]],
####################################################################################################
"GenISA_RenderTargetRead": ["",
    [("float4",                        "result"),
    [("int",                           "render target slot")],
    "ReadMem"]],
####################################################################################################
"GenISA_RenderTargetReadSampleFreq": ["",
    [("float4",                        "result"),
    [("int",                           "render target slot"),
     ("int",                           "sample index")],
    "ReadMem"]],
####################################################################################################
"GenISA_RuntimeValue": ["",
    [("any:float",                     "result"),
    [("int",                           "index")],
    "NoMem"]],
####################################################################################################
"GenISA_SampleOffsetX": ["",
    [("float",                         ""),
    [("int",                           "sample index")],
    "NoMem"]],
####################################################################################################
"GenISA_SampleOffsetY": ["",
    [("float",                         ""),
    [("int",                           "sample index")],
    "NoMem"]],
####################################################################################################
"GenISA_SetDebugReg": ["",
    [("int",                           "result (dbg0.1:ud)"),
    [("int",                           "dbg0.0:ud")],
    "None"]],
####################################################################################################
"GenISA_SetStream": ["",
    [("void",                          ""),
    [("int",                           "streamID"),
     ("int",                           "emitCount")],
    "None"]],
####################################################################################################
"GenISA_StackAlloca": ["",
    [("ptr_private",                   "result"),
    [("int",                           "offset")],
    "NoMem"]],
####################################################################################################
"GenISA_VLAStackAlloca": ["",
    [("ptr_private",                   "result"),
    [("int",                           "laneOffset"),
     ("int",                           "size")],
    "NoMem"]],
####################################################################################################
"GenISA_UnmaskedRegionBegin": ["",
    [("void",                          ""),
    [("void",                          "")],
    "None"]],
####################################################################################################
"GenISA_UnmaskedRegionEnd": ["",
    [("void",                          ""),
    [("void",                          "")],
    "None"]],
####################################################################################################
"GenISA_URBRead": ["",
    [("float8",                        "result"),
    [("int",                           "vertex index"),
     ("int",                           "URB owordOffset"
     )],
    "NoMem"]],
####################################################################################################
"GenISA_URBReadOutput": ["In-place data read using URB Write Handle",
    [("float8",                        ""),
    [("int",                           "owordOffset"
     )],
    "NoMem"]],
####################################################################################################
"GenISA_URBWrite": ["",
    [("void",                          ""),
    [("int",                           "urb offset"),
     ("int",                           "channel mask"),
     ("float",                         "x0"),
     ("float",                         "y0"),
     ("float",                         "z0"),
     ("float",                         "w0"),
     ("float",                         "x1"),
     ("float",                         "y1"),
     ("float",                         "z1"),
     ("float",                         "w1")],
    "None"]],
####################################################################################################
"GenISA_UpdateDiscardMask": ["update live pixel dmask from discard pixel mask",
    [("bool",                          ""),
    [("bool",                          ""),
     ("bool",                          "")],
    "None"]],
####################################################################################################
"GenISA_WaveAll": ["Accumulate all the active lanes",
    [("anyint",                        ""),
    [(0,                               "value"),
     ("char",                          "IGC:WaveOps")],
    "Convergent,InaccessibleMemOnly"]],
####################################################################################################
"GenISA_WaveBallot": ["All lanes get the same value",
    [("int",                           "return a bitfield with 1 for active lane with input true, "+\
                                       "0 for the rest."),
    [("bool",                          "Bool b")],
    "Convergent,InaccessibleMemOnly"]],
####################################################################################################
"GenISA_WaveClustered": ["Accumulate all active lanes within consecutive input clusters and "+\
                         "broadcast the result to associated output clusters. A k-cluster is "+\
                         "a sequence of values from k consecutive (not necessarily active) lanes, "+\
                         "such that: clusters are disjoint, size value is of "+\
                         "1 <= 2^p <= maxSubgroupSize, p >= 0.",
    [("anyint",                        "the result for n-th input cluster is replicated to "+\
                                       "n-th output cluster"),
    [(0,                               "value"),
     ("char",                          "IGC::WaveOps"),
     ("int",                           "size - must be a compile time constant and assumed > 1")],
    "Convergent,InaccessibleMemOnly"]],
####################################################################################################
"GenISA_WaveInverseBallot": ["",
    [("bool",                          "return value of n-th bit from the input bitfield"),
    [("int",                           "bitfield")],
    "Convergent,InaccessibleMemOnly"]],
####################################################################################################
"GenISA_WavePrefix": ["Accumulate and keep the intermediate results in each lane",
    [("anyint",                        "result"),
    [(0,                               "value"),
     ("char",                          "IGC::WaveOps"),
     ("bool",                          "type - either exclusive(0) or inclusive(1) operation"),
     ("bool",                          "mask - subset of lanes to participate in the computation.")],
    "Convergent,InaccessibleMemOnly"]],
####################################################################################################
"GenISA_WaveShuffleIndex": ["Read from a specific lane",
    [("anyint",                        "TODO: could be changed to anytype when support has "+\
                                       "been backported from llvm 3.7"),
    [(0,                               "value"),
     ("int",                           "lane"),
     ("int",                           "helperLaneMode : 0: not used; 1: used.")],
    "Convergent,NoMem"]],
####################################################################################################
"GenISA_WorkGroupAny": ["This intrinsic implies a barrier",
    [("int",                           ""),
    [("int",                           "")],
    "None"]],
####################################################################################################
"GenISA_add_pair": ["",
    [[("int",                          ""),
      ("int",                          "")],
    [("int",                           ""),
     ("int",                           ""),
     ("int",                           ""),
     ("int",                           "")],
    "NoMem"]],
####################################################################################################
"GenISA_add_rtz": ["",
    [("anyfloat",                      ""),
    [(0,                               ""),
     (0,                               "")],
    "NoMem"]],
####################################################################################################
"GenISA_atomiccounterinc": ["",
    [("int",                           "dst0 Contains the returned counter value"),
    [("anyptr",                        "Structured Buffer UaV with Count or Append flag")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_atomiccounterpredec": ["",
    [("int",                           "dst0 Contains the returned counter value"),
    [("anyptr",                        "Structured Buffer UAV with Count or Append flag")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_bfi": ["",
    [("int",                           "result"),
    [("int",                           "src0"),
     ("int",                           "src1"),
     ("int",                           "src2"),
     ("int",                           "src3")],
    "NoMem"]],
####################################################################################################
"GenISA_bfrev": ["",
    [("int",                           "result"),
    [("int",                           "src0")],
    "NoMem"]],
####################################################################################################
"GenISA_broadcastMessagePhase": ["",
    [("anyint",                        "result"),
    [("int",                           "message phases reference"),
     ("int",                           "id of message phase"),
     ("int",                           "id of DW of the message phase"),
     ("int",                           "width")],
    "None"]],
####################################################################################################
"GenISA_broadcastMessagePhaseV": ["",
    [("anyint",                        "result"),
    [("anyvector",                     "message phases reference"),
     ("int",                           "id of message phase"),
     ("int",                           "id of DW of the message phase"),
     ("int",                           "width")],
    "None"]],
####################################################################################################
"GenISA_cmpSADs": ["",
    [("void",                          "result"),
    [("int",                           "MVCurr"),
     ("int",                           "SADCurr"),
     ("int",                           "MVMin"),
     ("int",                           "SADMin")],
    "None"]],
####################################################################################################
"GenISA_cmpxchgatomicstructured": ["",
    [("int",                           ""),
    [("anyptr",                        "Dst Buffer"),
     ("int",                           "array index"),
     ("int",                           "byte offset in structure"),
     ("int",                           "src0"),
     ("int",                           "src1")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_createMessagePhases": ["",
    [("int",                           "result"),
    [("int",                           "num message phases to allocate and initialize with 0")],
    "None"]],
####################################################################################################
"GenISA_createMessagePhasesNoInit": ["",
    [("int",                           "result"),
    [("int",                           "num message phases to allocate (no init)")],
    "None"]],
####################################################################################################
"GenISA_createMessagePhasesNoInitV": ["",
    [("anyvector",                     "result"),
    [("int",                           "num message phases to allocate (no init)")],
    "None"]],
####################################################################################################
"GenISA_createMessagePhasesV": ["",
    [("anyvector",                     "result"),
    [("int",                           "num message phases to allocate and initialize with 0")],
    "None"]],
####################################################################################################
"GenISA_cycleCounter": ["",
    [("int2",                          ""),
    [],
    "None"]],
####################################################################################################
"GenISA_discard": ["",
    [("void",                          ""),
    [("bool",                          "condition")],
    "None"]],
####################################################################################################
"GenISA_dp4a_ss": ["",
    [("int",                           "result = dot(a * b) + c"),
    [("int",                           "c"),
     ("int",                           "a of char4"),
     ("int",                           "b of char4")],
    "NoMem"]],
####################################################################################################
"GenISA_dp4a_su": ["Accumulate byte-wise dot-product",
    [("int",                           "result = dot(a * b) + c"),
    [("int",                           "c"),
     ("int",                           "a of char4"),
     ("int",                           "b of uchar4")],
    "NoMem"]],
####################################################################################################
"GenISA_dp4a_us": ["Accumulate byte-wise dot-product",
    [("int",                           "result = dot(a * b) + c"),
    [("int",                           "c"),
     ("int",                           "a of uchar4"),
     ("int",                           "b of char4")],
    "NoMem"]],
####################################################################################################
"GenISA_dp4a_uu": ["Accumulate byte-wise dot-product",
    [("int",                           "result = dot(a * b) + c"),
    [("int",                           "c"),
     ("int",                           "a of uchar4"),
     ("int",                           "b of uchar4")],
    "NoMem"]],
####################################################################################################
# This is for generating a dummy instruction that won't be optimized away and can be used in cases
# where no-op calls need to preserve their debug info.
"GenISA_dummyInst": ["",
    [("void",                          ""),
    [],
    "None"]],
####################################################################################################
"GenISA_dwordatomicstructured": ["",
    [("int",                           ""),
    [("anyptr",                        "Dst Buffer"),
     ("int",                           "array index"),
     ("int",                           "byte offset in structure"),
     ("int",                           "src0"),
     ("int",                           "Instruction type (add, or, xor etc)")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_eu_id": ["returns the eu id that is defined in the state register 'PREDEFINED_SR0'",
    [("int",                           "result"),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_eu_thread_id": ["returns the eu id that is defined in the state register 'PREDEFINED_SR0'",
    [("int",                           "result"),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_eu_thread_pause": ["",
    [("void",                          ""),
    [("int",                           "")],
    "None"]],
####################################################################################################
"GenISA_evaluateSampler": ["",
    [("void",                          ""),
    [("anyvector",                     "")],
    "None"]],
####################################################################################################
"GenISA_extractMVAndSAD": ["",
    [("void",                          "result"),
    [("int",                           "Min MV loaded into from result"),
     ("int",                           "Min SAD loaded into from result"),
     ("int",                           "result from IME"),
     ("int",                           "MB block type")],
    "None"]],
####################################################################################################
"GenISA_f32tof16_rtz": ["",
    [("float",                         "result"),
    [("float",                         "input")],
    "NoMem"]],
####################################################################################################
"GenISA_fcmpxchgatomicraw": ["",
    [("anyfloat",                      ""),
    [("anyptr",                        "Dst Buffer"),
     ("int",                           "dst address"),
     (0,                               "src0"),
     (0,                               "src1")],
    "None"]],
####################################################################################################
"GenISA_fcmpxchgatomicrawA64": ["",
    [("anyfloat",                      ""),
    [("anyptr",                        "Dst Buffer"),
     ("anyptr",                        "dst address"),
     (0,                               "src0"),
     (0,                               "src1")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_fcmpxchgatomicstructured": ["",
    [("float",                         ""),
    [("anyptr",                        "Dst Buffer"),
     ("int",                           "array index"),
     ("int",                           "byte offset in structure"),
     ("float",                         "src0"),
     ("float",                         "src1")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_firstbitHi": ["",
    [("int",                           ""),
    [("int",                           "")],
    "NoMem"]],
####################################################################################################
"GenISA_firstbitLo": ["",
    [("int",                           "result"),
    [("int",                           "src0")],
    "NoMem"]],
####################################################################################################
"GenISA_firstbitShi": ["",
    [("int",                           "result"),
    [("int",                           "src0")],
    "NoMem"]],
####################################################################################################
"GenISA_floatatomicraw": ["",
    [("anyfloat",                      ""),
    [("anyptr",                        "Dst Buffer"),
     ("int",                           "dst address"),
     (0,                               "src0"),
     ("int",                           "Instruction type (add, or, xor etc)")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_floatatomicrawA64": ["",
    [("anyfloat",                      ""),
    [("anyptr",                        "Dst Buffer"),
     ("anyptr",                        "dst address"),
     (0,                               "src0"),
     ("int",                           "Instruction type (add, or, xor etc)")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_floatatomicstructured": ["",
    [("float",                         ""),
    [("anyptr",                        "Dst Buffer"),
     ("int",                           "array index"),
     ("int",                           "byte offset in structure"),
     ("float",                         "src0"),
     ("int",                           "Instruction type (add, or, xor etc)")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_flushsampler": ["",
    [("void",                          ""),
    [],
    "None"]],
####################################################################################################
"GenISA_fma_rtz": ["",
    [("anyfloat",                      ""),
    [(0,                               ""),
     (0,                               ""),
     (0,                               "")],
    "NoMem"]],
####################################################################################################
"GenISA_fma_rtp": ["",
    [("anyfloat",                      ""),
    [(0,                               ""),
     (0,                               ""),
     (0,                               "")],
    "NoMem"]],
####################################################################################################
"GenISA_fma_rtn": ["",
    [("anyfloat",                      ""),
    [(0,                               ""),
     (0,                               ""),
     (0,                               "")],
    "NoMem"]],
####################################################################################################
"GenISA_fsat": ["",
    [("anyfloat",                      "result"),
    [(0,                               "source")],
    "NoMem"]],
####################################################################################################
"GenISA_usat": ["",
    [("anyint",                        "result"),
    [(0,                               "source")],
    "NoMem"]],
####################################################################################################
"GenISA_isat": ["",
    [("anyint",                        "result"),
    [(0,                               "source")],
    "NoMem"]],
####################################################################################################
"GenISA_ftof_rte": ["",
    [("anyfloat",                      "result"),
    [("anyfloat",                      "input")],
    "NoMem"]],
####################################################################################################
"GenISA_ftof_rtn": ["",
    [("anyfloat",                      "result"),
    [("anyfloat",                      "input")],
    "NoMem"]],
####################################################################################################
"GenISA_ftof_rtp": ["",
    [("anyfloat",                      "result"),
    [("anyfloat",                      "input")],
    "NoMem"]],
####################################################################################################
"GenISA_ftof_rtz": ["",
    [("anyfloat",                      "result"),
    [("anyfloat",                      "input")],
    "NoMem"]],
####################################################################################################
"GenISA_ftoi_rte": ["",
    [("anyint",                        "result"),
    [("anyfloat",                      "input")],
    "NoMem"]],
####################################################################################################
"GenISA_ftoi_rtn": ["",
    [("anyint",                        "result"),
    [("anyfloat",                      "input")],
    "NoMem"]],
####################################################################################################
"GenISA_ftoi_rtp": ["",
    [("anyint",                        "result"),
    [("anyfloat",                      "input")],
    "NoMem"]],
####################################################################################################
"GenISA_ftoui_rte": ["",
    [("anyint",                        "result"),
    [("anyfloat",                      "input")],
    "NoMem"]],
####################################################################################################
"GenISA_ftoui_rtn": ["",
    [("anyint",                        "result"),
    [("anyfloat",                      "input")],
    "NoMem"]],
####################################################################################################
"GenISA_ftoui_rtp": ["",
    [("anyint",                        "result"),
    [("anyfloat",                      "input")],
    "NoMem"]],
####################################################################################################
"GenISA_gather4Cptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "coordinates ref"),
     (1,                               "coordinates u"),
     (1,                               "coordinates v"),
     (1,                               "coordinates r"),
     (1,                               "coordinates ai"),
     ("anyptr",                        "src buffer"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w"),
     ("int",                           "src channel select")],
    "NoMem"]],
####################################################################################################
"GenISA_gather4POCptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "coordinates ref"),
     (1,                               "coordinates u"),
     (1,                               "coordinates v"),
     ("int",                           "coordinates offu"),
     ("int",                           "coordinates offv"),
     (1,                               "coordinates r"),
     ("anyptr",                        "src buffer"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w"),
     ("int",                           "src channel offset")],
    "NoMem"]],
####################################################################################################
"GenISA_gather4POptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "coordinates u"),
     (1,                               "coordinates v"),
     ("int",                           "coordinates offu"),
     ("int",                           "coordinates offv"),
     (1,                               "coordinates r"),
     ("anyptr",                        "src buffer"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w"),
     ("int",                           "src channel select")],
    "NoMem"]],
####################################################################################################
"GenISA_gather4ptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "coordinates u"),
     (1,                               "coordinates v"),
     (1,                               "coordinates r"),
     (1,                               "coordinates ai"),
     ("anyptr",                        "src buffer"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w"),
     ("int",                           "src channel offset")],
    "NoMem"]],
####################################################################################################
"GenISA_getMessagePhase": ["",
    [("int",                           "result"),
    [("int",                           "message phase"),
     ("int",                           "id of message phase")],
    "None"]],
####################################################################################################
"GenISA_getMessagePhaseV": ["",
    [("int",                           "result"),
    [("anyvector",                     "message phases"),
     ("int",                           "id of message phase")],
    "None"]],
####################################################################################################
"GenISA_getMessagePhaseX": ["",
    [("anyint",                        "result"),
    [("int",                           "message phases reference"),
     ("int",                           "id of message phase"),
     ("int",                           "id of DW of the message phase")],
    "None"]],
####################################################################################################
"GenISA_getMessagePhaseXV": ["",
    [("anyint",                        "result"),
    [("anyvector",                     "message phases reference"),
     ("int",                           "id of message phase"),
     ("int",                           "id of DW of the message phase")],
    "None"]],
####################################################################################################
"GenISA_getR0": ["",
    [("anyvector",                        "result"),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_getSR0": ["sr0.# the state register",
    [("int",                           "result"),
    [("int",                           "index/offset of the subregister within sr0")],
    "None"]],
####################################################################################################
# This is separated from GenISA_getSR0 in order to get the first dword by itself
# because we want to assumes that sr0.0 is fully Read-Only because we want to perform
# CSE optimization on the calls.
"GenISA_getSR0_0": ["sr0.0 the first dword state register",
    [("int",                           "result"),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_globalSync": ["",
    [("void",                          ""),
    [],
    "Convergent"]],
####################################################################################################
"GenISA_hw_thread_id": ["returns the hardware thread id that is located at 'PREDEFINED_HW_TID'",
    [("int",                           "result"),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_hw_thread_id_alloca": ["returns the hardware thread id that is located at 'PREDEFINED_HW_TID' and this ID should be used only by alloca",
    [("int",                           "result"),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_ibfe": ["",
    [("int",                           "result"),
    [("int",                           "bit field width"),
     ("int",                           "bit field offset"),
     ("int",                           "bit field src")],
    "NoMem"]],
####################################################################################################
"GenISA_icmpxchgatomicraw": ["",
    [("anyint",                        ""),
    [("anyptr",                        "Dst Buffer"),
     ("int",                           "dst address"),
     (0,                               "src0"),
     (0,                               "src1")],
    "None"]],
####################################################################################################
"GenISA_icmpxchgatomicrawA64": ["",
    [("anyint",                        ""),
    [("anyptr",                        "Dst Buffer"),
     ("anyptr",                        "dst address"),
     (0,                               "src0"),
     (0,                               "src1")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_icmpxchgatomictyped": ["",
    [("anyint",                        ""),
    [("anyptr",                        "Dst Buffer"),
     ("int",                           "coordinates u"),
     ("int",                           "coordinates v"),
     ("int",                           "coordinates r"),
     (0,                               "src0"),
     (0,                               "src1")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_imulH": ["",
    [("anyint",                        "result"),
    [(0,                               "source0"),
     (0,                               "source1")],
    "NoMem"]],
####################################################################################################
"GenISA_intatomicraw": ["",
    [("anyint",                        ""),
    [("anyptr",                        "Dst Buffer"),
     ("int",                           "dst address"),
     (0,                               "src0"),
     ("int",                           "Instruction type (add, or, xor etc)")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_intatomicrawA64": ["",
    [("anyint",                        ""),
    [("anyptr",                        "Dst Buffer"),
     ("anyptr",                        "dst address"),
     (0,                               "src0"),
     ("int",                           "Instruction type (add, or, xor etc)")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_intatomictyped": ["",
    [("anyint",                        ""),
    [("anyptr",                        "Dst Buffer"),
     ("int",                           "coordinates u"),
     ("int",                           "coordinates v"),
     ("int",                           "coordinates r"),
     (0,                               "src0"),
     ("int",                           "Instruction type (add, or, xor etc)")],
    "ReadWriteArgMem"]],
####################################################################################################
"GenISA_is_uniform": ["",
    [("bool",                          ""),
    [("any",                           "")],
    "NoMem"]],
####################################################################################################
"GenISA_itof_rtn": ["",
    [("anyfloat",                      "result"),
    [("anyint",                        "input")],
    "NoMem"]],
####################################################################################################
"GenISA_itof_rtp": ["",
    [("anyfloat",                      "result"),
    [("anyint",                        "input")],
    "NoMem"]],
####################################################################################################
"GenISA_itof_rtz": ["",
    [("anyfloat",                      "result"),
    [("anyint",                        "input")],
    "NoMem"]],
####################################################################################################
"GenISA_ldmcsptr": ["",
    [("anyvector",                     "result"),
    [("anyint",                        "coordinates x"),
     (1,                               "coordinates y"),
     (1,                               "coordinates z"),
     (1,                               "lod"),
     ("anyptr",                        "resource"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "NoMem"]],
####################################################################################################
"GenISA_ldmsptr": ["",
    [("anyvector",                     "result"),
    [("int",                           "sampleindex"),
     ("int",                           "mcsl"),
     ("int",                           "mcsh"),
     ("int",                           "coordinates x"),
     ("int",                           "coordinates y"),
     ("int",                           "coordinates z"),
     ("int",                           "lod"),
     ("anyptr",                        "resource"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "NoMem"]],
####################################################################################################
"GenISA_ldmsptr16bit": ["",
    [("anyvector",                     "result"),
    [("short",                         "sampleindex"),
     ("short",                         "mcs0"),
     ("short",                         "mcs1"),
     ("short",                         "mcs2"),
     ("short",                         "mcs3"),
     ("short",                         "coordinates x"),
     ("short",                         "coordinates y"),
     ("short",                         "coordinates z"),
     ("short",                         "lod"),
     ("anyptr",                        "resource"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "NoMem"]],
####################################################################################################
"GenISA_ldptr": ["",
    [("anyvector",                     "result"),
    [("int",                           "coordinates x"),
     ("int",                           "coordinates y"),
     ("int",                           "coordinates z"),
     ("int",                           "lod"),
     ("anyptr",                        "src buffer"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "ReadArgMem"]],
####################################################################################################
"GenISA_ldraw_indexed": ["Read a scalar value from a buffer pointer at byte offset",
    [("any:float",                     ""),
    [("anyptr",                        "buffer pointer, result of GetBufferPtr"),
     ("int",                           "offset from the base pointer, in bytes"),
     ("int",                           "aligment in bytes"),
     ("bool",                          "volatile, must be an immediate")],
    "ReadArgMem"]],
####################################################################################################
"GenISA_ldrawvector_indexed": ["Read a vector from a buffer pointer at byte offset",
    [("anyvector",                     ""),
    [("anyptr",                        "buffer pointer, result of GetBufferPtr"),
     ("int",                           "offset from the base pointer, in bytes"),
     ("int",                           "aligment in bytes"),
     ("bool",                          "volatile, must be an immediate")],
    "ReadArgMem"]],
####################################################################################################
"GenISA_ldstructured": ["",
    [("float4",                        "result0"),
    [("anyptr",                        "src buffer"),
     ("int",                           "array index"),
     ("int",                           "byte offset in structure")],
    "ReadArgMem"]],
####################################################################################################
"GenISA_lodptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "coordinates u"),
     (1,                               "coordinates v"),
     (1,                               "coordinates r"),
     (1,                               "coordinates ai"),
     ("anyptr",                        "resource"),
     ("anyptr",                        "sampler")],
    "NoMem"]],
####################################################################################################
"GenISA_memoryfence": ["",
    [("void",                          ""),
    [("bool",                          "Commit Enable"),
     ("bool",                          "L3_Flush_RW_Data"),
     ("bool",                          "L3_Flush_Constant_Data"),
     ("bool",                          "L3_Flush_Texture_Data"),
     ("bool",                          "L3_Flush_Instructions"),
     ("bool",                          "Fence has global effect"),
     ("bool",                          "L1 Invalidate")],
    "Convergent"]],
####################################################################################################
"GenISA_mov_identity": ["",
    [("void",                          ""),
    [("int",                           "")],
    "None"]],
####################################################################################################
"GenISA_movcr": ["returns the specified sub register of the control register 'PREDEFINED_CR0'",
    [("int",                           "result"),
    [("int",                           "sub reg <0-3>")],
    "None"]],
####################################################################################################
"GenISA_movflag": ["return the contents of the flag register that the user specifies",
    [("int",                           "result"),
    [("int",                           "flag number")],
    "None"]],
####################################################################################################
"GenISA_mul_pair": ["",
    [[("int",                          ""),
      ("int",                          "")],
    [("int",                           ""),
     ("int",                           ""),
     ("int",                           ""),
     ("int",                           "")],
    "NoMem"]],
####################################################################################################
"GenISA_mul_rtz": ["",
    [("anyfloat",                      ""),
    [(0,                               ""),
     (0,                               "")],
    "NoMem"]],
####################################################################################################
"GenISA_pair_to_ptr": ["",
    [("anyptr",                        ""),
    [("int",                           ""),
     ("int",                           "")],
    "NoMem"]],
####################################################################################################
"GenISA_patchInstanceId": ["",
    [("int",                           "result"),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_ptr_to_pair": ["",
    [[("int",                          ""),
      ("int",                          "")],
    [("anyptr",                        "")],
    "NoMem"]],
####################################################################################################
"GenISA_readsurfaceinfoptr": ["",
    [("int16",                         "result : base address, width, Height, Depth, Mip count, "+\
                                                "Surface type, surface format, reserved"),
    [("anyptr",                        "source buffer"),
     ("int",                           "miplevel")],
    "NoMem"]],
####################################################################################################
"GenISA_resinfoptr": ["",
    [("int4",                          "result"),
    [("anyptr",                        "source buffer"),
     ("int",                           "miplevel")],
    "NoMem"]],
####################################################################################################
"GenISA_rsq": ["",
    [("anyfloat",                      "result"),
    [(0,                               "source")],
    "NoMem"]],
####################################################################################################
"GenISA_sampleBCptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "coordinates ref"),
     (1,                               "coordinates bias"),
     (1,                               "coordinates u"),
     (1,                               "coordinates v"),
     (1,                               "coordinates r"),
     (1,                               "coordinates ai"),
     ("anyptr",                        "src buffer"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "NoMem"]],
####################################################################################################
"GenISA_sampleBptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "bias"),
     (1,                               "coordinates u"),
     (1,                               "coordinates v"),
     (1,                               "coordinates r"),
     (1,                               "coordinates ai"),
     (1,                               "minlod"),
     ("anyptr",                        "resource"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "NoMem"]],
####################################################################################################
"GenISA_sampleCptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "coordinates ref"),
     (1,                               "coordinates u"),
     (1,                               "coordinates v"),
     (1,                               "coordinates r"),
     (1,                               "coordinates ai"),
     (1,                               "minlod"),
     ("anyptr",                        "resource"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "NoMem"]],
####################################################################################################
"GenISA_sampleDCptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "coordinates ref"),
     (1,                               "coordinates u"),
     (1,                               "gradient du from dx"),
     (1,                               "gradient du from dy"),
     (1,                               "coordinates v"),
     (1,                               "gradient dv from dx"),
     (1,                               "gradient dv from dy"),
     (1,                               "coordinates r"),
     (1,                               "gradient dr from dx"),
     (1,                               "gradient dr from dy"),
     (1,                               "coordinates ai"),
     ("anyptr",                        "resource"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "NoMem"]],
####################################################################################################
"GenISA_sampleDptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "coordinates u"),
     (1,                               "gradient du from dx"),
     (1,                               "gradient du from dy"),
     (1,                               "coordinates v"),
     (1,                               "gradient dv from dx"),
     (1,                               "gradient dv from dy"),
     (1,                               "coordinates r"),
     (1,                               "gradient dr from dx"),
     (1,                               "gradient dr from dy"),
     (1,                               "coordinates ai"),
     (1,                               "minlod"),
     ("anyptr",                        "resource"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "NoMem"]],
####################################################################################################
"GenISA_sampleKillPix": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "coordinates u"),
     (1,                               "coordinates v"),
     (1,                               "coordinates w"),
     ("anyptr",                        "texture index"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "NoMem"]],
####################################################################################################
"GenISA_sampleLCptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "coordinates ref"),
     (1,                               "coordinates lod"),
     (1,                               "coordinates u"),
     (1,                               "coordinates v"),
     (1,                               "coordinates r"),
     (1,                               "coordinates ai"),
     ("anyptr",                        "resource"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "NoMem"]],
####################################################################################################
"GenISA_sampleLptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "lod"),
     (1,                               "coordinates u"),
     (1,                               "coordinates v"),
     (1,                               "coordinates r"),
     (1,                               "coordinates ai"),
     ("anyptr",                        "resource"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "NoMem"]],
####################################################################################################
"GenISA_sampleinfoptr": ["",
    [("int4",                          "result"),
    [("anyptr",                        "source buffer")],
    "NoMem"]],
####################################################################################################
"GenISA_sampleptr": ["",
    [("anyvector",                     "result"),
    [("anyfloat",                      "coordinates u"),
     (1,                               "coordinates v"),
     (1,                               "coordinates r"),
     (1,                               "coordinates ai"),
     (1,                               "minlod"),
     ("anyptr",                        "resource"),
     ("anyptr",                        "sampler"),
     ("int",                           "immediate offset u"),
     ("int",                           "immediate offset v"),
     ("int",                           "immediate offset w")],
    "NoMem"]],
####################################################################################################
"GenISA_setMessagePhase": ["",
    [("int",                           "new message phase result"),
    [("int",                           "cur message phase"),
     ("int",                           "id of message phase"),
     ("int",                           "message phase value")],
    "None"]],
####################################################################################################
"GenISA_setMessagePhaseV": ["",
    [("anyvector",                     "new message phase result"),
    [(0,                               "cur message phase"),
     ("int",                           "id of message phase"),
     ("int",                           "message phase value")],
    "None"]],
####################################################################################################
"GenISA_setMessagePhaseX": ["",
    [("int",                           "new message phase result"),
    [("int",                           "curr message phase"),
     ("int",                           "id of message phase"),
     ("int",                           "id of DW of the message phase"),
     ("anyint",                        "new val")],
    "None"]],
####################################################################################################
"GenISA_setMessagePhaseXV": ["",
    [("anyvector",                     "new message phase result"),
    [(0,                               "curr message phase"),
     ("int",                           "id of message phase"),
     ("int",                           "id of DW of the message phase"),
     ("anyint",                        "new val")],
    "None"]],
####################################################################################################
"GenISA_setMessagePhaseX_legacy": ["",
    [("void",                          ""),
    [("int",                           "curr message phase"),
     ("int",                           "id of message phase"),
     ("int",                           "id of DW of the message phase"),
     ("anyint",                        "new val")],
    "None"]],
####################################################################################################
"GenISA_setMessagePhase_legacy": ["",
    [("void",                          ""),
    [("int",                           "curr message phase"),
     ("int",                           "id of message phase"),
     ("int",                           "message phase value")],
    "None"]],
####################################################################################################
"GenISA_simdBlockRead": ["",
    [("anyvector",                     ""),
    [("anyptr",                        "")],
    "ReadMem"]],
####################################################################################################
"GenISA_simdBlockReadBindless": ["",
    [("anyvector",                     ""),
    [("anyptr",                        ""),
     ("int",                           "")],
    "ReadMem"]],
####################################################################################################
"GenISA_simdBlockWrite": ["",
    [("void",                          ""),
    [("anyptr",                        ""),
     ("anyvector",                     "")],
    "None"]],
####################################################################################################
"GenISA_simdBlockWriteBindless": ["",
    [("void",                          ""),
    [("anyptr",                        ""),
     ("anyvector",                     ""),
     ("int",                           "")],
    "None"]],
####################################################################################################
"GenISA_simdGetMessagePhase": ["",
    [("anyint",                        "result"),
    [("int",                           "message phases"),
     ("int",                           "starting id of message phase"),
     ("int",                           "number of phases")],
    "None"]],
####################################################################################################
"GenISA_simdGetMessagePhaseV": ["",
    [("anyint",                        "result"),
    [("anyvector",                     "message phases"),
     ("int",                           "starting id of message phase"),
     ("int",                           "number of phases")],
    "None"]],
####################################################################################################
"GenISA_simdLaneId": ["",
    [("short",                         "result"),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_simdMediaBlockRead": ["",
    [("anyvector",                     ""),
    [("int",                           ""),
     ("int",                           ""),
     ("int",                           ""),
     ("int",                           "")],
    "None"]],
####################################################################################################
"GenISA_simdMediaBlockWrite": ["",
    [("void",                          ""),
    [("int",                           ""),
     ("int",                           ""),
     ("int",                           ""),
     ("int",                           ""),
     ("anyvector",                     "")],
    "None"]],
####################################################################################################
"GenISA_simdMediaRegionCopy": ["",
    [("void",                          ""),
    [("int",                           "destination"),
     ("int",                           "destination byte offset"),
     ("int",                           "destination hstride"),
     ("int",                           "destination num elements"),
     ("int",                           "source"),
     ("int",                           "source byte offset"),
     ("int",                           "source vertical stride"),
     ("int",                           "source width"),
     ("int",                           "source hstride"),
     ("int",                           "type size (for dst and src)"),
     ("int",                           "execution size"),
     ("int",                           "source num elements")],
    "None"]],
####################################################################################################
"GenISA_simdSetMessagePhase": ["",
    [("int",                           "new message phase result"),
    [("int",                           "curr message phase"),
     ("int",                           "starting id of message phase"),
     ("int",                           "number of phases"),
     ("int",                           "id of subreg per message phase"),
     ("int",                           "number of lanes per message phase"),
     ("anyint",                        "new val")],
    "None"]],
####################################################################################################
"GenISA_simdSetMessagePhaseV": ["",
    [("anyvector",                     "new message phase result"),
    [(0,                               "curr message phase"),
     ("int",                           "starting id of message phase"),
     ("int",                           "number of phases"),
     ("int",                           "id of subreg per message phase"),
     ("int",                           "number of lanes per message phase"),
     ("anyint",                        "new val")],
    "None"]],
####################################################################################################
"GenISA_simdShuffleDown": ["",
    [("anyint",                        "result"),
    [(0,                               "curr"),
     (0,                               "next"),
     ("int",                           "offset")],
    "Convergent,NoMem"]],
####################################################################################################
"GenISA_simdSize": ["",
    [("int",                           "result"),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_slice_id": ["returns the slice id that is defined in the state register 'PREDEFINED_SR0'",
    [("int",                           "result"),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_source_value": ["returns creates a mov from source to a null register",
    [("void",                          "result"),
    [("int",                           "register")],
    "None"]],
####################################################################################################
"GenISA_storeraw_indexed": ["Write a scalar value to a buffer pointer at byte offset",
    [("void",                          ""),
    [("anyptr",                        "buffer pointer, result of GetBufferPtr"),
     ("int",                           "offset from the base pointer, in bytes"),
     ("any:float",                     "value to store"),
     ("int",                           "aligment in bytes"),
     ("bool",                          "volatile, must be an immediate")],
    "None"]],
####################################################################################################
"GenISA_storerawvector_indexed": ["Write a vector to a buffer pointer at byte offset",
    [("void",                          ""),
    [("anyptr",                        "buffer pointer, result of GetBufferPtr"),
     ("int",                           "offset from the base pointer, in bytes"),
     ("anyvector",                     "value to store"),
     ("int",                           "aligment in bytes"),
     ("bool",                          "volatile, must be an immediate")],
    "None"]],
####################################################################################################
"GenISA_storestructured1": ["",
    [("void",                          ""),
    [("anyptr",                        "dst buffer"),
     ("int",                           "array index"),
     ("int",                           "byte offset in structure"),
     ("float",                         "src0 value to be stored")],
    "None"]],
####################################################################################################
"GenISA_storestructured2": ["",
    [("void",                          ""),
    [("anyptr",                        "dst buffer"),
     ("int",                           "array index"),
     ("int",                           "byte offset in structure"),
     ("float",                         "src0 value to be stored"),
     ("float",                         "src1 value to be stored")],
    "None"]],
####################################################################################################
"GenISA_storestructured3": ["",
    [("void",                          ""),
    [("anyptr",                        "dst buffer"),
     ("int",                           "array index"),
     ("int",                           "byte offset in structure"),
     ("float",                         "src0 value to be stored"),
     ("float",                         "src1 value to be stored"),
     ("float",                         "src2 value to be stored")],
    "None"]],
####################################################################################################
"GenISA_storestructured4": ["",
    [("void",                          ""),
    [("anyptr",                        "dst buffer"),
     ("int",                           "array index"),
     ("int",                           "byte offset in structure"),
     ("float",                         "src0 value to be stored"),
     ("float",                         "src1 value to be stored"),
     ("float",                         "src2 value to be stored"),
     ("float",                         "src3 value to be stored")],
    "None"]],
####################################################################################################
"GenISA_sub_group_dpas": ["XeHP SDV: dot product accumulate systolic",
    [("anyvector",                     "dst"),
    [("anyvector",                     "src0(acc)"),
     ("anyvector",                     "src1"),
     ("anyvector",                     "src2"),
     ("int",                           "src1's precision"),
     ("int",                           "src2's precision"),
     ("int",                           "systolic depth"),
     ("int",                           "repeat count"),
     ("bool",                          "isDpasw")],
    "Convergent","NoMem"]],
####################################################################################################
"GenISA_sub_pair": ["",
    [[("int",                          ""),
      ("int",                          "")],
    [("int",                           ""),
     ("int",                           ""),
     ("int",                           ""),
     ("int",                           "")],
    "NoMem"]],
####################################################################################################
"GenISA_subslice_id": ["returns the subslice id defined in the state register 'PREDEFINED_SR0'",
    [("int",                           "result"),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_dual_subslice_id": ["",
    [("int",                           ""),
    [],
    "NoMem"]],
####################################################################################################
"GenISA_threadgroupbarrier": ["",
    [("void",                          ""),
    [],
    "Convergent"]],
####################################################################################################
"GenISA_threadgroupbarrier_signal": ["",
    [("void",                          ""),
    [],
    "Convergent"]],
####################################################################################################
"GenISA_threadgroupbarrier_wait": ["",
    [("void",                          ""),
    [],
    "Convergent"]],
####################################################################################################
"GenISA_typedmemoryfence": ["",
    [("void",                          ""),
    [("bool",                          "")],
    "Convergent"]],
####################################################################################################
"GenISA_typedread": ["",
    [("float4",                        "Return type"),
    [("anyptr",                        "Src Buffer"),
     ("int",                           "coordinates u"),
     ("int",                           "coordinates v"),
     ("int",                           "coordinates r"),
     ("int",                           "LOD")],
    "ReadArgMem"]],
####################################################################################################
"GenISA_typedwrite": ["",
    [("void",                          ""),
    [("anyptr",                        "Dst Buffer to write to"),
     ("int",                           "coordinates u"),
     ("int",                           "coordinates v"),
     ("int",                           "coordinates r"),
     ("int",                           "LOD"),
     ("float",                         "x"),
     ("float",                         "y"),
     ("float",                         "z"),
     ("float",                         "w (4 elements since uav_typed will always write "+\
                                       "4 destinations)")],
    "None"]],
####################################################################################################
"GenISA_uaddc": ["",
    [("anyvector",                     "result"),
    [("anyint",                        "source0"),
     (1,                               "source1")],
    "NoMem"]],
####################################################################################################
"GenISA_uavSerializeAll": ["",
    [("void",                          ""),
    [],
    "None"]],
####################################################################################################
"GenISA_uavSerializeOnResID": ["",
    [("void",                          ""),
    [("int",                           "")],
    "None"]],
####################################################################################################
"GenISA_ubfe": ["",
    [("int",                           "result"),
    [("int",                           "bit field width"),
     ("int",                           "bit field offset"),
     ("int",                           "bit field src")],
    "NoMem"]],
####################################################################################################
"GenISA_uitof_rtn": ["",
    [("anyfloat",                      "result"),
    [("anyint",                        "input")],
    "NoMem"]],
####################################################################################################
"GenISA_uitof_rtp": ["",
    [("anyfloat",                      "result"),
    [("anyint",                        "input")],
    "NoMem"]],
####################################################################################################
"GenISA_uitof_rtz": ["",
    [("anyfloat",                      "result"),
    [("anyint",                        "input")],
    "NoMem"]],
####################################################################################################
"GenISA_umulH": ["",
    [("anyint",                        "result"),
    [(0,                               "source0"),
     (0,                               "source1")],
    "NoMem"]],
####################################################################################################
"GenISA_usubb": ["",
    [("anyvector",                     "result0"),
    [("anyint",                        "source0"),
     (1,                               "source1")],
    "NoMem"]],
####################################################################################################
"GenISA_vaBoolCentroid": ["",
    [("void",                          "result"),
    [("ptr_local",                     "output buffer"),
     ("float2",                        "coordinates"),
     ("int2",                          "size"),
     ("int",                           "src image bti"),
     ("int",                           "sampler (accelerator) id")],
    "None"]],
####################################################################################################
"GenISA_vaBoolSum": ["",
    [("void",                          "result"),
    [("ptr_local",                     "output buffer"),
     ("float2",                        "coordinates"),
     ("int2",                          "size"),
     ("int",                           "src image bti"),
     ("int",                           "sampler (accelerator) id")],
    "None"]],
####################################################################################################
"GenISA_vaCentroid": ["",
    [("void",                          "result"),
    [("ptr_local",                     "output buffer"),
     ("float2",                        "coordinates"),
     ("int2",                          "size"),
     ("int",                           "src image bti"),
     ("int",                           "sampler (accelerator) id")],
    "None"]],
####################################################################################################
"GenISA_vaConvolve": ["",
    [("void",                          "result"),
    [("ptr_local",                     "output buffer"),
     ("float2",                        "coordinates"),
     ("int",                           "src image bti"),
     ("int",                           "sampler (accelerator) id")],
    "None"]],
####################################################################################################
"GenISA_vaConvolveGRF_16x1": ["New 2D convolve function w/o using SLM, 16x1 version",
    [("short",                         "result"),
    [("float2",                        "coordinates"),
     ("int",                           "src image bti"),
     ("int",                           "sampler (accelerator) id")],
    "None"]],
####################################################################################################
"GenISA_vaConvolveGRF_16x4": ["New 2D convolve function w/o using SLM, 16x4 version",
    [("short4",                        "result"),
    [("float2",                        "coordinates"),
     ("int",                           "src image bti"),
     ("int",                           "sampler (accelerator) id")],
    "None"]],
####################################################################################################
"GenISA_vaDilate": ["",
    [("void",                          "result"),
    [("ptr_local",                     "output buffer"),
     ("float2",                        "coordinates"),
     ("int",                           "src image bti"),
     ("int",                           "sampler (accelerator) id")],
    "None"]],
####################################################################################################
"GenISA_vaErode": ["",
    [("void",                          "result"),
    [("ptr_local",                     "output buffer"),
     ("float2",                        "coordinates"),
     ("int",                           "src image bti"),
     ("int",                           "sampler (accelerator) id")],
    "None"]],
####################################################################################################
"GenISA_vaMinMax": ["",
    [("void",                          "result"),
    [("ptr_local",                     "output buffer"),
     ("float2",                        "coordinates"),
     ("int",                           "src image bti"),
     ("int",                           "sampler (accelerator) id")],
    "None"]],
####################################################################################################
"GenISA_vaMinMaxFilter": ["",
    [("void",                          "result"),
    [("ptr_local",                     "output buffer"),
     ("float2",                        "coordinates"),
     ("int",                           "src image bti"),
     ("int",                           "sampler (accelerator) id")],
    "None"]],
####################################################################################################
"GenISA_vectorUniform": ["used by compiler to mark an array in GRF",
    [("anyvector",                     "return the vector value"),
    [],
    "None"]],
####################################################################################################
"GenISA_vmeSendFBR": ["",
    [("void",                          "result"),
    [("int",                           "output buffer"),
     ("int",                           "universal header input"),
     ("int",                           "fbr header input"),
     ("int",                           "src image bti"),
     ("int",                           "ref image bti"),
     ("int",                           "interMbMode"),
     ("int",                           "subMbShape"),
     ("int",                           "subMbPredMode")],
    "None"]],
####################################################################################################
"GenISA_vmeSendFBR2": ["",
    [("int4",                          "result"),
    [("int4",                          "header input"),
     ("int",                           "src image bti"),
     ("int",                           "fwd ref image bti"),
     ("int",                           "bwd ref image bti")],
    "None"]],
####################################################################################################
"GenISA_vmeSendIME": ["",
    [("void",                          "result"),
    [("int",                           "output buffer"),
     ("int",                           "universal header input"),
     ("int",                           "ime header input"),
     ("int",                           "src image bti"),
     ("int",                           "ref image bti"),
     ("int",                           "ref0 coordinate"),
     ("int",                           "ref1 coordinate"),
     ("int",                           "cost center")],
    "None"]],
####################################################################################################
"GenISA_vmeSendIME2": ["",
    [("anyvector",                     "result"),
    [("anyvector",                     "header input"),
     ("int",                           "src image bti"),
     ("int",                           "fwd ref image bti"),
     ("int",                           "bwd ref image bti"),
     ("int",                           "stream mode")],
    "None"]],
####################################################################################################
"GenISA_vmeSendSIC": ["",
    [("void",                          "result"),
    [("int",                           "output buffer"),
     ("int",                           "universal header input"),
     ("int",                           "sic header input"),
     ("int",                           "src image bti"),
     ("int",                           "ref0 image bti"),
     ("int",                           "ref1 image bti")],
    "None"]],
####################################################################################################
"GenISA_vmeSendSIC2": ["",
    [("int4",                          "result"),
    [("int4",                          "header input"),
     ("int",                           "src image bti"),
     ("int",                           "fwd ref image bti"),
     ("int",                           "bwd ref image bti")],
    "None"]],
####################################################################################################
"GenISA_wavebarrier": ["",
    [("void",                          ""),
    [],
    "Convergent"]],
####################################################################################################
"GenISA_frc": ["GENISA_frc for emitting HW Frc",
    [("float",                        "output"),
    [("float",                        "src0")],
    "NoMem"]]
}
