#if   !defined(__MEMENTO_HPP)
#define __MEMENTO_HPP

/*
   CoreLinux++ 
   Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace corelinux
{
   DECLARE_CLASS( Memento );

   /**
   Memento knows its Mediator object, communicates with its mediator 
   whenever it would have otherwise communicated with another Memento. 
   */

   class Memento
   {
   public:

      //
      // Constructors and destructor
      //

                        /**
                        Default constructor 
                        */

                        Memento( void ) ;

                        /**
                        Copy constructor 
                        @param Memento const referencee
                        */

                        Memento( MementoCref );

                        /// Virtual destructor 

      virtual           ~Memento( void );   

      //
      // Operator overloads
      //

               /// Assignment operator

               MementoRef   operator=( MementoCref );

               /// Equality operator

               bool operator==( MementoCref ) const;

               /// In-Equality operator

               bool operator!=( MementoCref ) const;
      //
      // Accessors
      //

      //
      // Mutators
      //

   protected:


   private:

   };
}

#endif // if !defined(__MEMENTO_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/07 03:41:47 $
   $Locker:  $
*/


