/* $Id: AbstractProjectItem.cpp 410943 2013-08-22 20:54:31Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'gbproj.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/gbproj/AbstractProjectItem.hpp>
#include <serial/objostr.hpp>
#include <serial/objistr.hpp>
#include <connect/ncbi_conn_stream.hpp>
// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CAbstractProjectItem::~CAbstractProjectItem(void)
{
}


void CAbstractProjectItem::UserOp_Assign(const CSerialUserOp& object)
{
    const CAbstractProjectItem* item =
        dynamic_cast<const CAbstractProjectItem*>(&object);
    if (item  &&  item->m_OtherObject) {
        m_OtherObject.Reset
            (static_cast<CSerialObject*>
                (item->m_OtherObject->GetThisTypeInfo()->Create())
            );
        m_OtherObject->Assign(*item->m_OtherObject);
    }
}


bool CAbstractProjectItem::UserOp_Equals(const CSerialUserOp& object) const
{
    const CAbstractProjectItem* item =
        dynamic_cast<const CAbstractProjectItem*>(&object);
    if (item) {
        if (m_OtherObject  &&  item->m_OtherObject) {
            return m_OtherObject->Equals(*item->m_OtherObject);
        } else if (m_OtherObject  ||  item->m_OtherObject) {
            return false;
        } else {
            return true;
        }
    } else {
        return false;
    }
}


void CAbstractProjectItem::Set(CSerialObject& object)
{
    SetType(object.GetThisTypeInfo()->GetName());
    m_OtherObject.Reset(&object);
}


const CSerialObject& CAbstractProjectItem::Get(void) const
{
    return *m_OtherObject;
}


const CSerialObject* CAbstractProjectItem::GetObject(void) const
{
    return m_OtherObject.GetPointer();
}


void CAbstractProjectItem::PreWrite() const
{
    if (m_OtherObject) {
        CConn_MemoryStream ostr;
        {{
            auto_ptr<CObjectOStream> os
                (CObjectOStream::Open(eSerial_AsnBinary, ostr));
            os->Write(m_OtherObject, m_OtherObject->GetThisTypeInfo());
        }}

        CAbstractProjectItem& mutable_item =
            const_cast<CAbstractProjectItem&>(*this);

        vector<char>& data = mutable_item.SetData();
        data.clear();
        data.resize(ostr.tellp() - CT_POS_TYPE(0));
        ostr.read(&data[0], data.size());
    }
}


void CAbstractProjectItem::PostRead()
{
    const string& type = GetType();
    const CTypeInfo* info = CClassTypeInfoBase::GetClassInfoByName(type);
    if (info) {
        try {
            CRef<CSerialObject> ref(static_cast<CSerialObject*>(info->Create()));
            m_OtherObject.Reset();

            static const ESerialDataFormat fmts[] = {
                eSerial_AsnBinary,
                eSerial_AsnText,
            };

            for (size_t i = 0;  i < sizeof(fmts) / sizeof(ESerialDataFormat);  ++i) {
                try {
                    CNcbiIstrstream istr(&GetData()[0], GetData().size());
                    auto_ptr<CObjectIStream> is
                        (CObjectIStream::Open(fmts[i], istr));
                    is->Read(ref, ref->GetThisTypeInfo());

                    m_OtherObject = ref;
                    return;
                }
                catch (CSerialException& e) {
                    ERR_POST("CAbstractProjectItem::PostRead(): "
                             "failed to deserialize other item: " << e);
                }
            }

            throw runtime_error("invalid format");
        }
        catch (CException& e) {
            LOG_POST(Error << "failed to deserialize abstract object: " << e);
            throw;
        }
    } else {
        NCBI_THROW(CException, eUnknown,
                   "CAbstractProjectItem::PostRead(): "
                   "failed to find object info for type: " + type);
    }
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1752, CRC32: 436ebd35 */
