/*
 * acl_getname.c: Getname functions for the PAX module.
 *
 * Author and Copyright (C) 1999-2005 Amon Ott (ao@rsbac.org)
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License as
 *      published by the Free Software Foundation, version 2.
 *
 * Last modified 06/01/2004.
 */

#include <rsbac/types.h>
#include <rsbac/pax_getname.h>
#include <rsbac/helpers.h>
#include <rsbac/error.h>

#ifdef __KERNEL__
#include <linux/string.h>
#else
#include <string.h>
#include <stdio.h>
#endif

char *pax_print_flags(char *string, rsbac_pax_flags_t flags)
{
	sprintf(string, "%c%c%c%c%c%c",
		flags & PF_PAX_PAGEEXEC ? 'P' : 'p',
		flags & PF_PAX_EMUTRAMP ? 'E' : 'e',
		flags & PF_PAX_MPROTECT ? 'M' : 'm',
		flags & PF_PAX_RANDMMAP ? 'R' : 'r',
		flags & PF_PAX_RANDEXEC ? 'X' : 'x',
		flags & PF_PAX_SEGMEXEC ? 'S' : 's');
	return string;
}

#ifndef __KERNEL__
rsbac_pax_flags_t pax_strtoflags(char *string,
				 rsbac_pax_flags_t init_flags)
{
	char *p = string;
	rsbac_pax_flags_t add_flags = 0;
	rsbac_pax_flags_t remove_flags = 0;

	if (!p)
		return init_flags;
	while (*p) {
		switch (*p) {
		case 'P':
			add_flags |= PF_PAX_PAGEEXEC;
			break;
		case 'p':
			remove_flags |= PF_PAX_PAGEEXEC;
			break;
		case 'E':
			add_flags |= PF_PAX_EMUTRAMP;
			break;
		case 'e':
			remove_flags |= PF_PAX_EMUTRAMP;
			break;
		case 'M':
			add_flags |= PF_PAX_MPROTECT;
			break;
		case 'm':
			remove_flags |= PF_PAX_MPROTECT;
			break;
		case 'R':
			add_flags |= PF_PAX_RANDMMAP;
			break;
		case 'r':
			remove_flags |= PF_PAX_RANDMMAP;
			break;
		case 'X':
			add_flags |= PF_PAX_RANDEXEC;
			break;
		case 'x':
			remove_flags |= PF_PAX_RANDEXEC;
			break;
		case 'S':
			add_flags |= PF_PAX_SEGMEXEC;
			break;
		case 's':
			remove_flags |= PF_PAX_SEGMEXEC;
			break;
		case 'z':
			remove_flags = RSBAC_PAX_ALL_FLAGS;
			break;
		case 'a':
			add_flags = RSBAC_PAX_ALL_FLAGS;
			break;
		default:
			break;
		}
		p++;
	}
	return (init_flags | add_flags) & ~remove_flags;
}
#endif
